/*
 * Decompiled with CFR 0.152.
 */
package tools.time;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeZoneDateFormat
extends DateFormat {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzzz");

    public TimeZoneDateFormat() {
        this.setCalendar(this.dateFormat.getCalendar());
        this.setNumberFormat(this.dateFormat.getNumberFormat());
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.dateFormat.format(date, toAppendTo, fieldPosition);
    }

    public Date parse(String source, ParsePosition pos) {
        String[] parts = source.split(" ");
        if (parts.length < 3) {
            return null;
        }
        String tz = parts[2];
        TimeZone timeZone = TimeZone.getTimeZone(tz);
        try {
            String newDateStr = parts[0] + " " + parts[1] + " " + timeZone.getDisplayName();
            Date date = this.dateFormat.parse(newDateStr);
            pos.setIndex(source.length());
            return date;
        }
        catch (ParseException ex) {
            return null;
        }
    }
}

