/*
 * Decompiled with CFR 0.152.
 */
package tools.time;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class DateUtils {
    private static final Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public static Date getUtcTimeNow() {
        return new Date();
    }

    @NotNull
    public static Date fromDotNetTicks(long ticks) {
        long msValue = (ticks - 621355968000000000L) / 10000L;
        return new Date(msValue);
    }

    public static long toDotNetTicks(@NotNull Date date) {
        return 621355968000000000L + date.getTime() * 10000L;
    }
}

