/*
 * Decompiled with CFR 0.152.
 */
package tools.stereometry;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;

@XmlType
@XmlAccessorType(value=XmlAccessType.NONE)
public class FloatVector3 {
    @NotNull
    public static FloatVector3 zero = new FloatVector3(0.0f, 0.0f, 0.0f);
    @XmlAttribute
    private float x;
    @XmlAttribute
    private float y;
    @XmlAttribute
    private float z;

    public FloatVector3() {
    }

    public FloatVector3(float _x, float _y, float _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public FloatVector3(@NotNull FloatVector3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    @NotNull
    public FloatVector3 add(@NotNull FloatVector3 other) {
        return new FloatVector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public FloatVector3 sub(@NotNull FloatVector3 other) {
        return new FloatVector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public FloatVector3 div(float divider) {
        return new FloatVector3(this.x / divider, this.y / divider, this.z / divider);
    }

    public FloatVector3 mul(float mul) {
        return new FloatVector3(this.x * mul, this.y * mul, this.z * mul);
    }

    public float distanceTo(@NotNull FloatVector3 other) {
        float sq = (this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y) + (this.z - other.z) * (this.z - other.z);
        return (float)Math.sqrt(sq);
    }

    public float getLength() {
        return this.distanceTo(zero);
    }

    public void normalize() {
        float length = this.getLength();
        this.x /= length;
        this.y /= length;
        this.z /= length;
    }

    @NotNull
    public FloatVector3 getNormalized() {
        FloatVector3 normalized = new FloatVector3(this.x, this.y, this.z);
        normalized.normalize();
        return normalized;
    }

    @NotNull
    public FloatVector3 getXZProjection() {
        return new FloatVector3(this.x, 0.0f, this.z);
    }

    @NotNull
    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    @NotNull
    public static FloatVector3 lerp(@NotNull FloatVector3 start, @NotNull FloatVector3 end, float factor) {
        return new FloatVector3(start.getX() * (1.0f - factor) + end.getX() * factor, start.getY() * (1.0f - factor) + end.getY() * factor, start.getZ() * (1.0f - factor) + end.getZ() * factor);
    }
}

