/*
 * Decompiled with CFR 0.152.
 */
package tools.random;

import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.planimetry.IntVector2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameRandom
extends Random {
    @NotNull
    private static final GameRandom instance = new GameRandom(0L);

    private GameRandom(long seed) {
        super(seed);
    }

    @NotNull
    public static GameRandom getInstance() {
        return instance;
    }

    public final <T> void permuteElements(@NotNull List<T> list) {
        for (int i = list.size() - 1; i > 0; --i) {
            int j = this.nextInt(i + 1);
            T x = list.get(i);
            list.set(i, list.get(j));
            list.set(j, x);
        }
    }

    @NotNull
    public IntVector2 getRandomPoint(int minX, int maxX, int minY, int maxY) {
        return new IntVector2(minX + this.nextInt(maxX - minX + 1), minY + this.nextInt(maxY - minY + 1));
    }

    @Nullable
    public <T> T pickRandom(@NotNull List<T> variants) {
        if (variants.isEmpty()) {
            return null;
        }
        return variants.get(this.nextInt(variants.size()));
    }

    public float getUniformInRange(float min, float max) {
        return min + this.nextFloat() * (max - min);
    }
}

