/*
 * Decompiled with CFR 0.152.
 */
package tools.planimetry;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;

@XmlType
@XmlAccessorType(value=XmlAccessType.NONE)
public class IntVector2 {
    public static IntVector2 zero = new IntVector2(0, 0);
    @XmlAttribute
    private int x;
    @XmlAttribute
    private int y;

    public IntVector2() {
    }

    public IntVector2(int _x, int _y) {
        this.x = _x;
        this.y = _y;
    }

    public IntVector2(@NotNull IntVector2 other) {
        this.x = other.x;
        this.y = other.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void normalizeByCoords() {
        this.x = this.x != 0 ? this.x / Math.abs(this.x) : 0;
        this.y = this.y != 0 ? this.y / Math.abs(this.y) : 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IntVector2)) {
            return false;
        }
        IntVector2 otherVec = (IntVector2)other;
        return this.x == otherVec.x && this.y == otherVec.y;
    }

    public float distanceTo(@NotNull IntVector2 other) {
        float sq = (this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y);
        return (float)Math.sqrt(sq);
    }

    @NotNull
    public IntVector2 add(@NotNull IntVector2 other) {
        return new IntVector2(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public IntVector2 sub(@NotNull IntVector2 other) {
        return new IntVector2(this.x - other.getX(), this.y - other.getY());
    }

    public int hashCode() {
        return 31 * this.x + this.y;
    }

    @NotNull
    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }
}

