/*
 * Decompiled with CFR 0.152.
 */
package tools.planimetry;

import org.jetbrains.annotations.NotNull;

public class FloatVector2 {
    @NotNull
    private static FloatVector2 zero = new FloatVector2(0.0f, 0.0f);
    private float x;
    private float y;

    @NotNull
    public static FloatVector2 getZero() {
        return zero;
    }

    public FloatVector2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public FloatVector2(@NotNull FloatVector2 other) {
        this.x = other.x;
        this.y = other.y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float distanceTo(@NotNull FloatVector2 other) {
        float sq = (this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y);
        return (float)Math.sqrt(sq);
    }

    @NotNull
    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }
}

