/*
 * Decompiled with CFR 0.152.
 */
package tools.planimetry;

import org.jetbrains.annotations.NotNull;
import tools.planimetry.FloatVector2;

public class Circle {
    @NotNull
    private static Circle nullCircle = new Circle(FloatVector2.getZero(), 0.0f);
    @NotNull
    private final FloatVector2 center;
    private final float radius;

    @NotNull
    public static Circle getNullCircle() {
        return nullCircle;
    }

    public Circle(@NotNull FloatVector2 _center, float _radius) {
        this.center = _center;
        this.radius = _radius;
    }

    public boolean isInside(@NotNull FloatVector2 point) {
        return this.center.distanceTo(point) < this.radius;
    }

    @NotNull
    public FloatVector2 getCenter() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }
}

