/*
 * Decompiled with CFR 0.152.
 */
package tools.dataStructures;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<K, V> {
    @NotNull
    private final K first;
    @NotNull
    private final V second;

    @NotNull
    public static <K extends Serializable, V extends Serializable> Pair<K, V> valueOf(@NotNull K first, @NotNull V second) {
        return new Pair<K, V>(first, second);
    }

    public Pair(@NotNull K first, @NotNull V second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)obj;
        return this.first.equals(pair.first) && this.second.equals(pair.second);
    }

    public int hashCode() {
        return this.first.hashCode() * 19 + this.second.hashCode() * 13;
    }

    @NotNull
    public String toString() {
        return '[' + this.first.toString() + ", " + this.second.toString();
    }

    @NotNull
    public final K getFirst() {
        return this.first;
    }

    @NotNull
    public final V getSecond() {
        return this.second;
    }
}

