/*
 * Decompiled with CFR 0.152.
 */
package tools.containers;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NoOrderCollection<T>
extends AbstractCollection<T>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 1486462608246810117L;
    private static final int INITIAL_CAPACITY = 10;
    @NotNull
    private T[] array;
    private int size = 0;

    public NoOrderCollection(int initialCapacity) {
        this.array = new Object[initialCapacity > 0 ? initialCapacity : 10];
    }

    public NoOrderCollection() {
        this(10);
    }

    @Override
    public boolean add(@Nullable T element) {
        this.ensureCapacityFor(this.size + 1);
        this.array[this.size++] = element;
        return true;
    }

    public boolean containsElement(@Nullable T element) {
        for (int i = 0; i < this.size; ++i) {
            if ((this.array[i] != null || element != null) && (this.array[i] == null || !this.array[i].equals(element))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ListIter();
    }

    @Nullable
    public T get(int i) {
        if (i >= this.size()) {
            throw new IndexOutOfBoundsException("index is " + i + ", size is " + this.size);
        }
        return this.array[i];
    }

    @Nullable
    public T getFast(int i) {
        return this.array[i];
    }

    public void removeAtIndex(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index is " + index + ", size is " + this.size);
        }
        this.array[index] = this.array[this.size - 1];
        this.array[this.size - 1] = null;
        this.ensureCapacityFor(this.size - 1);
        --this.size;
    }

    public void set(int i, @Nullable T element) {
        if (i >= this.size()) {
            throw new IndexOutOfBoundsException("index is " + i + ", size is " + this.size);
        }
        this.array[i] = element;
    }

    public void setFast(int i, @Nullable T element) {
        this.array[i] = element;
    }

    private void ensureCapacityFor(int newSize) {
        if (newSize >= this.array.length || newSize >= 10 && newSize < this.array.length / 4) {
            Object[] newArray = new Object[newSize * 2];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListIter
    implements Iterator<T> {
        private int current = 0;

        private ListIter() {
        }

        @Override
        public boolean hasNext() {
            return this.current < NoOrderCollection.this.size();
        }

        @Override
        @Nullable
        public T next() {
            if (this.current >= NoOrderCollection.this.size()) {
                throw new NoSuchElementException();
            }
            return NoOrderCollection.this.array[this.current++];
        }

        @Override
        public void remove() {
            if (this.current == 0) {
                throw new IllegalStateException("next hasn't been called yet");
            }
            --this.current;
            NoOrderCollection.this.removeAtIndex(this.current);
        }
    }
}

