/*
 * Decompiled with CFR 0.152.
 */
package tools.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tools.planimetry.IntVector2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StraightPathfinder {
    @NotNull
    public static List<IntVector2> findPath(@NotNull IntVector2 p1, @NotNull IntVector2 p2) {
        ArrayList<IntVector2> result = new ArrayList<IntVector2>();
        int sx = (int)Math.signum(p2.getX() - p1.getX());
        int sy = (int)Math.signum(p2.getY() - p1.getY());
        if (sx == 0 && sy == 0) {
            result.add(p1);
            return result;
        }
        int x = p1.getX();
        int y = p1.getY();
        float[] dists = new float[3];
        IntVector2[] points = new IntVector2[3];
        while (p2.getX() != x || p2.getY() != y) {
            result.add(new IntVector2(x, y));
            points[0] = new IntVector2(x + sx, y + sy);
            points[1] = new IntVector2(x + sx, y + 0);
            points[2] = new IntVector2(x + 0, y + sy);
            for (int i = 0; i < points.length; ++i) {
                dists[i] = p2.distanceTo(points[i]);
            }
            int minDist = 0;
            for (int i = 1; i < dists.length; ++i) {
                if (!(dists[i] < dists[minDist])) continue;
                minDist = i;
            }
            x = points[minDist].getX();
            y = points[minDist].getY();
        }
        result.add(new IntVector2(x, y));
        return result;
    }

    public static void main(String[] args) {
        List<IntVector2> path1 = StraightPathfinder.findPath(new IntVector2(0, 0), new IntVector2(5, 5));
        List<IntVector2> path2 = StraightPathfinder.findPath(new IntVector2(5, 5), new IntVector2(0, 0));
        List<IntVector2> path3 = StraightPathfinder.findPath(new IntVector2(0, 0), new IntVector2(0, 5));
        List<IntVector2> path4 = StraightPathfinder.findPath(new IntVector2(3, 10), new IntVector2(0, 0));
        System.out.println("Path1 len " + path1.size());
        System.out.println("Path2 len " + path2.size());
        System.out.println("Path3 len " + path3.size());
        System.out.println("Path4 len " + path4.size());
    }
}

