/*
 * Decompiled with CFR 0.152.
 */
package tools.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tools.planimetry.IntVector2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedPointBrezenham {
    @NotNull
    public static List<IntVector2> createStraightPath(@NotNull IntVector2 p1, @NotNull IntVector2 p2) {
        ArrayList<IntVector2> result = new ArrayList<IntVector2>();
        if (p1.equals(p2)) {
            return result;
        }
        int Px = Math.abs(p2.getX() - p1.getX());
        int Py = Math.abs(p2.getY() - p1.getY());
        int s1 = (int)Math.signum(p2.getX() - p1.getX());
        int s2 = (int)Math.signum(p2.getY() - p1.getY());
        boolean swapped = false;
        if (Py < Px) {
            int tmp = Px;
            Px = Py;
            Py = tmp;
            swapped = true;
        }
        int e = 2 * Py - Px;
        int x = p1.getX();
        int y = p1.getY();
        for (int i = 0; i < Px; ++i) {
            result.add(new IntVector2(x, y));
            while (e >= 0) {
                if (swapped) {
                    x += s1;
                } else {
                    y += s2;
                }
                e -= 2 * Px;
            }
            if (swapped) {
                y += s2;
            } else {
                x += s1;
            }
            e += 2 * Py;
        }
        result.add(p2);
        return result;
    }

    public static void main(String[] args) {
        List<IntVector2> path1 = FixedPointBrezenham.createStraightPath(new IntVector2(0, 0), new IntVector2(5, 5));
        List<IntVector2> path2 = FixedPointBrezenham.createStraightPath(new IntVector2(5, 5), new IntVector2(0, 0));
        List<IntVector2> path3 = FixedPointBrezenham.createStraightPath(new IntVector2(0, 0), new IntVector2(0, 5));
        List<IntVector2> path4 = FixedPointBrezenham.createStraightPath(new IntVector2(3, 10), new IntVector2(0, 0));
        System.out.println("Path1 len " + path1.size());
        System.out.println("Path2 len " + path2.size());
    }
}

