/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.datapack.templates.contract.ContractMode;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IProfileProtoGateway;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.profileproto.RQ_ProfileAvailableNickName;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeCash;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeExp;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeFraction;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeLevel;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeNickName;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeRating;
import ru.quadcom.tactics.profileproto.RQ_ProfileCreate;
import ru.quadcom.tactics.profileproto.RQ_ProfileGet;
import ru.quadcom.tactics.profileproto.RQ_ProfileGetAll;
import ru.quadcom.tactics.profileproto.RQ_ProfileGetByNickName;
import ru.quadcom.tactics.profileproto.RQ_ProfileGetPastCache;
import ru.quadcom.tactics.profileproto.RQ_ProfileRatingCalculation;
import ru.quadcom.tactics.profileproto.RQ_ProfileRemovetByNickName;
import ru.quadcom.tactics.profileproto.RQ_ProfileUpdateAvatar;
import ru.quadcom.tactics.profileproto.RS_ProfileAvailableNickName;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeCash;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeExp;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeFraction;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeLevel;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeNickName;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeRating;
import ru.quadcom.tactics.profileproto.RS_ProfileCreate;
import ru.quadcom.tactics.profileproto.RS_ProfileGet;
import ru.quadcom.tactics.profileproto.RS_ProfileGetAll;
import ru.quadcom.tactics.profileproto.RS_ProfileGetByNickName;
import ru.quadcom.tactics.profileproto.RS_ProfileRatingCalculation;
import ru.quadcom.tactics.profileproto.RS_ProfileRemoveByNickName;
import ru.quadcom.tactics.profileproto.RS_ProfileUpdateAvatar;

public abstract class AbstractProfileProtoGateway
extends AbstractProtoGateway
implements IProfileProtoGateway {
    public AbstractProfileProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<Profile> create(long accountId, String nickname, String avatar, int fractionId) {
        RQ_ProfileCreate request = RQ_ProfileCreate.newBuilder().setAccountId(accountId).setNickname(nickname).setAvatar(avatar).setFractionId(fractionId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CREATE, Packet.PacketType.RS_PROFILE_CREATE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileCreate.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getProfile()));
    }

    @Override
    public CompletionStage<List<Profile>> getAll(long accountId) {
        RQ_ProfileGetAll request = RQ_ProfileGetAll.newBuilder().setAccountId(accountId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_GET_ALL, Packet.PacketType.RS_PROFILE_GET_ALL, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileGetAll.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getProfileList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<Profile> updateAvatar(long accountId, long profileId, String avatar) {
        RQ_ProfileUpdateAvatar request = RQ_ProfileUpdateAvatar.newBuilder().setAccountId(accountId).setProfileId(profileId).setAvatar(avatar).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_UPDATE_AVATAR, Packet.PacketType.RS_PROFILE_UPDATE_AVATAR, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileUpdateAvatar.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getProfile()));
    }

    @Override
    public CompletionStage<Optional<Profile>> get(long accountId, long profileId) {
        RQ_ProfileGet request = RQ_ProfileGet.newBuilder().setAccountId(accountId).setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_GET, Packet.PacketType.RS_PROFILE_GET, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileGet.parseFrom((ByteString)bytes))).thenApply(message -> message.hasProfile() ? Optional.of(Transformer.fromProto(message.getProfile())) : Optional.empty());
    }

    @Override
    public CompletionStage<Profile> changeCash(long accountId, long profileId, long changeCash) {
        RQ_ProfileChangeCash request = RQ_ProfileChangeCash.newBuilder().setAccountId(accountId).setProfileId(profileId).setChangeCash(changeCash).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_CAHS, Packet.PacketType.RS_PROFILE_CHANGE_CAHS, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeCash.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getProfile()));
    }

    @Override
    public CompletionStage<Optional<Profile>> getByNickName(String nickName) {
        RQ_ProfileGetByNickName request = RQ_ProfileGetByNickName.newBuilder().setNickname(nickName).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_GET_BY_NICKNAME, Packet.PacketType.RS_PROFILE_GET_BY_NICKNAME, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileGetByNickName.parseFrom((ByteString)bytes))).thenApply(message -> message.hasProfile() ? Optional.of(Transformer.fromProto(message.getProfile())) : Optional.empty());
    }

    @Override
    public CompletionStage<Optional<Profile>> removeByNickName(String nickName) {
        RQ_ProfileRemovetByNickName request = RQ_ProfileRemovetByNickName.newBuilder().setNickname(nickName).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_REMOVE_BY_NICKNAME, Packet.PacketType.RS_PROFILE_REMOVE_BY_NICKNAME, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileRemoveByNickName.parseFrom((ByteString)bytes))).thenApply(message -> message.hasProfile() ? Optional.of(Transformer.fromProto(message.getProfile())) : Optional.empty());
    }

    @Override
    public CompletionStage<Boolean> availableNickName(String nickName) {
        RQ_ProfileAvailableNickName request = RQ_ProfileAvailableNickName.newBuilder().setNickname(nickName).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_AVAILABLE_NICKNAME, Packet.PacketType.RS_PROFILE_AVAILABLE_NICKNAME, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileAvailableNickName.parseFrom((ByteString)bytes))).thenApply(RS_ProfileAvailableNickName::getAvailable);
    }

    @Override
    public CompletionStage<Boolean> calcRating(long profileId1, long profileId2, long winnerProfileId) {
        RQ_ProfileRatingCalculation request = RQ_ProfileRatingCalculation.newBuilder().setProfileId1(profileId1).setProfileId2(profileId2).setWinnerProfileId(winnerProfileId).setContractMode(ru.quadcom.tactics.typeproto.ContractMode.valueOf((String)ContractMode.PVP.name())).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_RATING_CALCULATION, Packet.PacketType.RS_PROFILE_RATING_CALCULATION, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileRatingCalculation.parseFrom((ByteString)bytes))).thenApply(RS_ProfileRatingCalculation::getResult);
    }

    @Override
    public CompletionStage<Boolean> calcRating(long profileId1, long profileId2, long winnerProfileId, ContractMode contractMode) {
        RQ_ProfileRatingCalculation request = RQ_ProfileRatingCalculation.newBuilder().setProfileId1(profileId1).setProfileId2(profileId2).setWinnerProfileId(winnerProfileId).setContractMode(ru.quadcom.tactics.typeproto.ContractMode.valueOf((String)contractMode.name())).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_RATING_CALCULATION, Packet.PacketType.RS_PROFILE_RATING_CALCULATION, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileRatingCalculation.parseFrom((ByteString)bytes))).thenApply(RS_ProfileRatingCalculation::getResult);
    }

    @Override
    public CompletionStage<Boolean> changeNickName(long accountId, long profileId, String newNickName) {
        RQ_ProfileChangeNickName request = RQ_ProfileChangeNickName.newBuilder().setProfileId(profileId).setAccountId(accountId).setNickname(newNickName).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_NICKNAME, Packet.PacketType.RS_PROFILE_CHANGE_NICKNAME, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeNickName.parseFrom((ByteString)bytes))).thenApply(RS_ProfileChangeNickName::getResult);
    }

    @Override
    public CompletionStage<Void> changeExp(long accountId, long profileId, long deltaExp) {
        RQ_ProfileChangeExp request = RQ_ProfileChangeExp.newBuilder().setProfileId(profileId).setAccountId(accountId).setDeltaExp(deltaExp).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_EXP, Packet.PacketType.RS_PROFILE_CHANGE_EXP, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeExp.parseFrom((ByteString)bytes))).thenApply(response -> null);
    }

    @Override
    public CompletionStage<Boolean> changeFraction(long accountId, long profileId, int fractionId) {
        RQ_ProfileChangeFraction request = RQ_ProfileChangeFraction.newBuilder().setAccountId(accountId).setProfileId(profileId).setFractionId(fractionId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_FRACTION, Packet.PacketType.RS_PROFILE_CHANGE_FRACTION, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeFraction.parseFrom((ByteString)bytes))).thenApply(RS_ProfileChangeFraction::getResult);
    }

    @Override
    public CompletionStage<Boolean> changeRating(long accountId, long profileId, double rating) {
        RQ_ProfileChangeRating request = RQ_ProfileChangeRating.newBuilder().setAccountId(accountId).setProfileId(profileId).setRating(rating).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_RATING, Packet.PacketType.RS_PROFILE_CHANGE_RATING, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeRating.parseFrom((ByteString)bytes))).thenApply(RS_ProfileChangeRating::getResult);
    }

    @Override
    public CompletionStage<Boolean> changeLevel(long accountId, long profileId, int level) {
        RQ_ProfileChangeLevel request = RQ_ProfileChangeLevel.newBuilder().setAccountId(accountId).setProfileId(profileId).setLevel(level).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_LEVEL, Packet.PacketType.RS_PROFILE_CHANGE_LEVEL, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeLevel.parseFrom((ByteString)bytes))).thenApply(RS_ProfileChangeLevel::getResult);
    }

    @Override
    public CompletionStage<Optional<Profile>> getPastCache(long accountId, long profileId) {
        RQ_ProfileGetPastCache request = RQ_ProfileGetPastCache.newBuilder().setAccountId(accountId).setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_GET_PAST_CACHE, Packet.PacketType.RS_PROFILE_GET_PAST_CACHE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileGet.parseFrom((ByteString)bytes))).thenApply(message -> message.hasProfile() ? Optional.of(Transformer.fromProto(message.getProfile())) : Optional.empty());
    }
}

