/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;

public class OpenleadXmlConverter {
    private static final Logger logger = LoggerFactory.getLogger(OpenleadXmlConverter.class);

    public static String convertMessageList(List<BuilderMessageOpenlead.MessageOpenlead> list) {
        final StringBuilder stringBuilder = new StringBuilder();
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    stringBuilder.append((char)b);
                }
            });
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            DTD newLine = eventFactory.createDTD("\n");
            eventWriter.add(eventFactory.createStartDocument());
            eventWriter.add(eventFactory.createStartElement("", "", "events"));
            eventWriter.add(newLine);
            for (BuilderMessageOpenlead.MessageOpenlead message : list) {
                eventWriter.add(eventFactory.createStartElement("", "", "item"));
                eventWriter.add(newLine);
                OpenleadXmlConverter.createElementKeyValue(eventWriter, eventFactory, "userId", message.getUserId());
                OpenleadXmlConverter.createElementKeyValue(eventWriter, eventFactory, "event", message.getEvent());
                OpenleadXmlConverter.createElementKeyValue(eventWriter, eventFactory, "value", message.getValue());
                OpenleadXmlConverter.createElementKeyValue(eventWriter, eventFactory, "time", Long.toString(message.getTime()));
                eventWriter.add(eventFactory.createEndElement("", "", "item"));
                eventWriter.add(newLine);
            }
            eventWriter.add(eventFactory.createEndElement("", "", "events"));
            eventWriter.add(newLine);
            eventWriter.add(eventFactory.createEndDocument());
            eventWriter.close();
        }
        catch (Exception e) {
            logger.error("OpenleadXmlConverter Exception", (Throwable)e);
        }
        String result = stringBuilder.toString();
        logger.debug("OpenleadXmlConverter result = " + result);
        return result;
    }

    private static void createElementKeyValue(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String key, String value) throws XMLStreamException {
        eventWriter.add(eventFactory.createDTD("\t"));
        eventWriter.add(eventFactory.createStartElement("", "", key));
        eventWriter.add(eventFactory.createCharacters(value));
        eventWriter.add(eventFactory.createEndElement("", "", key));
        eventWriter.add(eventFactory.createDTD("\n"));
    }
}

