/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.bank.OrderType;
import ru.quadcom.exceptions.ErrorException;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IBankProtoGateway;
import ru.quadcom.tactics.bankproto.RQ_ConfirmOrder;
import ru.quadcom.tactics.bankproto.RQ_CreateOrder;
import ru.quadcom.tactics.bankproto.RQ_FailOrder;
import ru.quadcom.tactics.bankproto.RQ_GetBankAccount;
import ru.quadcom.tactics.bankproto.RS_ConfirmOrder;
import ru.quadcom.tactics.bankproto.RS_CreateOrder;
import ru.quadcom.tactics.bankproto.RS_FailOrder;
import ru.quadcom.tactics.bankproto.RS_GetBankAccount;
import ru.quadcom.tactics.baseproto.Packet;

public abstract class AbstractBankProtoGateway
extends AbstractProtoGateway
implements IBankProtoGateway {
    public AbstractBankProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<Long> getBankAccountAmount(long profileId) {
        RQ_GetBankAccount request = RQ_GetBankAccount.newBuilder().setProfileId(profileId).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_GET_BANK_ACCOUNT, Packet.PacketType.RS_GET_BANK_ACCOUNT, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_GetBankAccount.parseFrom((ByteString)packet.getBody()))).thenApply(RS_GetBankAccount::getAmount);
    }

    @Override
    public <T> CompletionStage<T> createAndProcessOrder(long profileId, long delta, OrderType type, Function<Long, CompletionStage<T>> action) {
        RQ_CreateOrder request = RQ_CreateOrder.newBuilder().setProfileId(profileId).setDelta(delta).setOrderType(type.ordinal()).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_CREATE_ORDER, Packet.PacketType.RS_CREATE_ORDER, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_CreateOrder.parseFrom((ByteString)packet.getBody()))).thenCompose(response -> {
            long orderId = response.getOrderId();
            return ((CompletionStage)action.apply(orderId)).handle((result, e) -> {
                if (e != null) {
                    RQ_FailOrder failRequest = RQ_FailOrder.newBuilder().setOrderId(orderId).build();
                    return this.sendProtoGetResponse(Packet.PacketType.RQ_FAIL_ORDER, Packet.PacketType.RS_FAIL_ORDER, (GeneratedMessageV3)failRequest, false).thenApply(packet -> this.parse(() -> RS_FailOrder.parseFrom((ByteString)packet.getBody()))).thenApply(failResponse -> {
                        throw new ErrorException("Error handle action for order " + orderId, e);
                    });
                }
                RQ_ConfirmOrder confirmRequest = RQ_ConfirmOrder.newBuilder().setOrderId(orderId).build();
                return this.sendProtoGetResponse(Packet.PacketType.RQ_CONFIRM_ORDER, Packet.PacketType.RS_CONFIRM_ORDER, (GeneratedMessageV3)confirmRequest, false).thenApply(packet -> this.parse(() -> RS_ConfirmOrder.parseFrom((ByteString)packet.getBody()))).thenApply(confirmResponse -> result);
            }).thenCompose(handleResult -> handleResult);
        });
    }
}

