/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import java.util.concurrent.CompletionStage;
import play.libs.Json;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.service.to.service.ServicesSecrets;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.gateway.IConfigServiceGateway;
import ru.quadcom.prototool.gateway.IServiceID;

@Singleton
public class ConfigServiceGateway
implements IConfigServiceGateway {
    private final String configurationURL;
    private final WSClient wsClient;
    private final String environmentName;

    @Inject
    public ConfigServiceGateway(Config config, WSClient wsClient) {
        this.configurationURL = config.getString("configuration.url");
        this.wsClient = wsClient;
        this.environmentName = config.getString("configuration.env_name");
    }

    @Override
    public CompletionStage<String> getServiceUrl(IServiceID serviceID) {
        WSRequest request = this.wsClient.url(String.format("%s/configuration/find", this.configurationURL));
        request = request.addHeader("X-Service-Access-Token", ConfigServiceGateway.getConfigurationToken());
        request = request.addQueryParameter("app_name", "X-Tactics");
        request = request.addQueryParameter("env_name", this.environmentName);
        request = request.addQueryParameter("name_start", "service." + serviceID.getName());
        return request.get().thenApply(response -> {
            if (response.getStatus() != 200) {
                throw new WarningException("Status " + response.getStatus(), 1);
            }
            String protocol = null;
            String host = null;
            String port = null;
            JsonNode node = Json.parse((String)response.getBody());
            for (JsonNode jsonNode : node) {
                String name = jsonNode.get("name").asText();
                if (name.equals("service." + serviceID.getName() + ".protocol")) {
                    protocol = jsonNode.get("value").asText();
                    continue;
                }
                if (name.equals("service." + serviceID.getName() + ".port")) {
                    port = jsonNode.get("value").asText();
                    continue;
                }
                if (!name.equals("service." + serviceID.getName() + ".host")) continue;
                host = jsonNode.get("value").asText();
            }
            if (protocol == null || host == null || port == null) {
                return null;
            }
            return protocol + "://" + host + ":" + port;
        });
    }

    private static String getConfigurationToken() {
        ServiceToServiceToken token = ServiceToServiceToken.createAccessToken((ServicesSecrets)ServicesSecrets.PROFILE);
        return token.encode(ServicesSecrets.CONFIGURATION);
    }
}

