/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool;

import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.ProtoHandler;
import ru.quadcom.prototool.gateway.messages.stc.AbstractCommand;
import ru.quadcom.tactics.baseproto.Packet;

public abstract class AbstractProtoService2 {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProtoService2.class);
    private static final Map<Packet.PacketType, Pair<Packet.PacketType, Supplier<ProtoHandler>>> map = Maps.newHashMap();

    protected static void registrationHandler(Packet.PacketType requestType, Packet.PacketType responseType, Supplier<ProtoHandler> handler) {
        map.put(requestType, (Pair<Packet.PacketType, Supplier<ProtoHandler>>)ImmutablePair.of((Object)responseType, handler));
    }

    public CompletionStage<byte[]> handleRequest(Http.RequestBody body) {
        try {
            Packet request = Packet.parseFrom((byte[])body.asBytes().toArray());
            Pair<Packet.PacketType, Supplier<ProtoHandler>> pair = map.get(request.getType());
            Packet.PacketType packetType = (Packet.PacketType)pair.getKey();
            ProtoHandler protoHandler = (ProtoHandler)((Supplier)pair.getValue()).get();
            return protoHandler.process0(request.getType(), request.getBody()).thenApply(response -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("response " + packetType + "\n" + response.toString());
                }
                Packet.Builder builder = Packet.newBuilder().setType(packetType).setBody(((GeneratedMessageV3)response).toByteString());
                Queue<AbstractCommand> commands = protoHandler.getCommands();
                while (!commands.isEmpty()) {
                    Packet.ProtoCommand command = commands.poll().toProto();
                    if (logger.isDebugEnabled()) {
                        logger.debug("response command" + packetType + "\n" + command.toString());
                    }
                    builder.addCommand(command);
                }
                return builder.build().toByteArray();
            });
        }
        catch (InvalidProtocolBufferException e) {
            throw new WarningException("Proto handled error", 1);
        }
    }
}

