/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.operator.Operator;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.ISquadProtoGateway;
import ru.quadcom.prototool.gateway.messages.sts.squad.BattleResultMessage;
import ru.quadcom.prototool.gateway.messages.sts.squad.ClientBattleResultMessage;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.squadproto.RQ_SquadAdd;
import ru.quadcom.tactics.squadproto.RQ_SquadBattleResult;
import ru.quadcom.tactics.squadproto.RQ_SquadChangeSkillPoints;
import ru.quadcom.tactics.squadproto.RQ_SquadClientBattleResult;
import ru.quadcom.tactics.squadproto.RQ_SquadCreate;
import ru.quadcom.tactics.squadproto.RQ_SquadCreateOperator;
import ru.quadcom.tactics.squadproto.RQ_SquadGet;
import ru.quadcom.tactics.squadproto.RQ_SquadGetAll;
import ru.quadcom.tactics.squadproto.RQ_SquadGetSquad;
import ru.quadcom.tactics.squadproto.RQ_SquadHealSquad;
import ru.quadcom.tactics.squadproto.RQ_SquadLevelUp;
import ru.quadcom.tactics.squadproto.RQ_SquadRemove;
import ru.quadcom.tactics.squadproto.RQ_SquadSetPlace;
import ru.quadcom.tactics.squadproto.RQ_SquadUpdateOperators;
import ru.quadcom.tactics.squadproto.RS_SquadAdd;
import ru.quadcom.tactics.squadproto.RS_SquadBattleResult;
import ru.quadcom.tactics.squadproto.RS_SquadChangeSkillPoints;
import ru.quadcom.tactics.squadproto.RS_SquadClientBattleResult;
import ru.quadcom.tactics.squadproto.RS_SquadCreate;
import ru.quadcom.tactics.squadproto.RS_SquadCreateOperator;
import ru.quadcom.tactics.squadproto.RS_SquadGet;
import ru.quadcom.tactics.squadproto.RS_SquadGetAll;
import ru.quadcom.tactics.squadproto.RS_SquadGetSquad;
import ru.quadcom.tactics.squadproto.RS_SquadHealSquad;
import ru.quadcom.tactics.squadproto.RS_SquadLevelUp;
import ru.quadcom.tactics.squadproto.RS_SquadRemove;
import ru.quadcom.tactics.squadproto.RS_SquadSetPlace;
import ru.quadcom.tactics.squadproto.RS_SquadUpdateOperators;

public abstract class AbstractSquadProtoGateway
extends AbstractProtoGateway
implements ISquadProtoGateway {
    public AbstractSquadProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<Operator> create(long accountId, long profileId) {
        RQ_SquadCreate request = RQ_SquadCreate.newBuilder().setAccountId(accountId).setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_CREATE, Packet.PacketType.RS_SQUAD_CREATE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadCreate.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getOperator()));
    }

    @Override
    public CompletionStage<Operator> createOperator(long accountId, long profileId, int classId, int rarityId) {
        RQ_SquadCreateOperator request = RQ_SquadCreateOperator.newBuilder().setAccountId(accountId).setProfileId(profileId).setClassId(classId).setRarityId(rarityId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_CREATE_OPERATOR, Packet.PacketType.RS_SQUAD_CREATE_OPERATOR, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadCreateOperator.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getOperator()));
    }

    @Override
    public CompletionStage<Operator> add(Profile profile, Operator operator) {
        RQ_SquadAdd request = RQ_SquadAdd.newBuilder().setProfile(Transformer.toProto(profile)).setOperator(Transformer.toProto(operator)).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_ADD, Packet.PacketType.RS_SQUAD_ADD, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadAdd.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getOperator()));
    }

    @Override
    public CompletionStage<Optional<Operator>> get(long profileId, long operatorId) {
        RQ_SquadGet request = RQ_SquadGet.newBuilder().setProfileId(profileId).setOperatorId(operatorId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_GET, Packet.PacketType.RS_SQUAD_GET, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadGet.parseFrom((ByteString)bytes))).thenApply(message -> message.hasOperator() ? Optional.of(Transformer.fromProto(message.getOperator())) : Optional.empty());
    }

    @Override
    public CompletionStage<List<Operator>> getAll(long accountId, long profileId) {
        RQ_SquadGetAll request = RQ_SquadGetAll.newBuilder().setAccountId(accountId).setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_GET_ALL, Packet.PacketType.RS_SQUAD_GET_ALL, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadGetAll.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getOperatorList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<List<Operator>> getSquad(long profileId) {
        RQ_SquadGetSquad request = RQ_SquadGetSquad.newBuilder().setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_GET_SQUAD, Packet.PacketType.RS_SQUAD_GET_SQUAD, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadGetSquad.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getOperatorList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<List<Operator>> setPlace(long profileId, long operatorId, int place) {
        RQ_SquadSetPlace request = RQ_SquadSetPlace.newBuilder().setProfileId(profileId).setOperatorId(operatorId).setPlace(place).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_SET_PLACE, Packet.PacketType.RS_SQUAD_SET_PLACE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadSetPlace.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getOperatorList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<List<Item>> remove(long accountId, long profileId, long operatorId) {
        RQ_SquadRemove request = RQ_SquadRemove.newBuilder().setAccountId(accountId).setProfileId(profileId).setOperatorId(operatorId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_REMOVE, Packet.PacketType.RS_SQUAD_REMOVE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadRemove.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getAddedItemList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<Operator> changeSkillPoints(long profileId, long operatorId, int skillPointsDelta) {
        RQ_SquadChangeSkillPoints request = RQ_SquadChangeSkillPoints.newBuilder().setProfileId(profileId).setOperatorId(operatorId).setSkillPointsDelta(skillPointsDelta).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_CHANGE_SKILL_POINTS, Packet.PacketType.RS_SQUAD_CHANGE_SKILL_POINTS, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadChangeSkillPoints.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getOperator()));
    }

    @Override
    public CompletionStage<Void> battleResult(BattleResultMessage battleResultMessage) {
        RQ_SquadBattleResult request = RQ_SquadBattleResult.newBuilder().addAllResults((Iterable)StreamEx.of(battleResultMessage.getResults()).map(battleResult -> RQ_SquadBattleResult.BattleResult.newBuilder().setProfileId(battleResult.getProfileId()).setOperatorId(battleResult.getOperatorId()).setExperience(battleResult.getExperience()).setStrengthActionCounter(battleResult.getStrengthActionCounter()).setPerceptionActionCounter(battleResult.getPerceptionActionCounter()).setIntelligenceActionCounter(battleResult.getIntelligenceActionCounter()).setKnackActionCounter(battleResult.getKnackActionCounter()).setEnduranceActionCounter(battleResult.getEnduranceActionCounter()).setNeedHealingHP(battleResult.getNeedHealingHP()).build()).toList()).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_BATTLE_RESULT, Packet.PacketType.RS_SQUAD_BATTLE_RESULT, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadBattleResult.parseFrom((ByteString)bytes))).thenApply(message -> null);
    }

    @Override
    public CompletionStage<ClientBattleResultMessage> clientBattleResult(long profileId) {
        RQ_SquadClientBattleResult request = RQ_SquadClientBattleResult.newBuilder().setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_CLIENT_BATTLE_RESULT, Packet.PacketType.RS_SQUAD_CLIENT_BATTLE_RESULT, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadClientBattleResult.parseFrom((ByteString)bytes))).thenApply(message -> new ClientBattleResultMessage(StreamEx.of((Collection)message.getOperatorInfoList()).map(info -> new ClientBattleResultMessage.OperatorInfo(Transformer.fromProto(info.getOperator()), info.getCurrentHp(), info.getHealHp(), info.getFullHp(), info.getHealPrice())).toList()));
    }

    @Override
    public CompletionStage<Long> healSquad(long accountId, long profileId) {
        RQ_SquadHealSquad request = RQ_SquadHealSquad.newBuilder().setProfileId(profileId).setAccountId(accountId).build();
        return this.sendProto(Packet.PacketType.RQ_SQUAD_HEAL_SQUAD, Packet.PacketType.RS_SQUAD_HEAL_SQUAD, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_SquadHealSquad.parseFrom((ByteString)bytes))).thenApply(RS_SquadHealSquad::getChangeCash);
    }

    @Override
    public CompletionStage<Void> updateOperators(List<Operator> operators) {
        RQ_SquadUpdateOperators request = RQ_SquadUpdateOperators.newBuilder().addAllOperator((Iterable)StreamEx.of(operators).map(Transformer::toProto).toList()).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SQUAD_UPDATE_OPERATORS, Packet.PacketType.RS_SQUAD_UPDATE_OPERATORS, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_SquadUpdateOperators.parseFrom((ByteString)packet.getBody()))).thenApply(message -> null);
    }

    @Override
    public CompletionStage<Operator> levelUp(long operatorId, int level) {
        RQ_SquadLevelUp request = RQ_SquadLevelUp.newBuilder().setOperatorId(operatorId).setLevel(level).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SQUAD_LEVEL_UP, Packet.PacketType.RS_SQUAD_LEVEL_UP, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_SquadLevelUp.parseFrom((ByteString)packet.getBody()))).thenApply(RS_SquadLevelUp::getOperator).thenApply(Transformer::fromProto);
    }
}

