/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool;

import com.google.common.collect.Queues;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.prototool.gateway.messages.stc.AbstractCommand;
import ru.quadcom.tactics.baseproto.Packet;

public abstract class ProtoHandler<T, U extends AbstractMessage.Builder<U>, V extends GeneratedMessageV3> {
    private static final Logger logger = LoggerFactory.getLogger(ProtoHandler.class);
    private Parser<T> requestParser;
    private Supplier<U> responseBuilder;
    private Queue<AbstractCommand> commands = Queues.newConcurrentLinkedQueue();

    public ProtoHandler(Supplier<Parser<T>> requestParser, Supplier<U> responseBuilder) {
        this.requestParser = requestParser.get();
        this.responseBuilder = responseBuilder;
    }

    private T parse(ByteString body) throws InvalidProtocolBufferException {
        return (T)this.requestParser.parseFrom(body);
    }

    public CompletionStage<V> process0(Packet.PacketType requestType, ByteString body) throws InvalidProtocolBufferException {
        T request = this.parse(body);
        if (logger.isDebugEnabled()) {
            logger.debug("request " + requestType + "\n" + request.toString());
        }
        return this.process(request, (AbstractMessage.Builder)this.responseBuilder.get());
    }

    protected abstract CompletionStage<V> process(T var1, U var2);

    public Queue<AbstractCommand> getCommands() {
        return this.commands;
    }

    public boolean addCommands(AbstractCommand command) {
        return this.commands.offer(command);
    }
}

