/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import ru.quadcom.exceptions.WarningException;

public abstract class AbstractHttpGateway {
    private final WSClient wsClient;
    private final String url;

    public AbstractHttpGateway(String url, WSClient wsClient) {
        this.wsClient = wsClient;
        this.url = url;
    }

    protected RequestWrapper getRequest(String path, boolean withToken) {
        WSRequest request = this.wsClient.url(this.url + path);
        if (withToken) {
            request.addHeader("X-Service-Access-Token", this.getToken());
        }
        return new RequestWrapper(request);
    }

    protected RequestWrapper getRequest(String rootPath, String path, boolean withToken) {
        WSRequest request = this.wsClient.url(rootPath + path);
        if (withToken) {
            request.addHeader("X-Service-Access-Token", this.getToken());
        }
        return new RequestWrapper(request);
    }

    protected abstract String getToken();

    protected static class RequestWrapper {
        private WSRequest request;
        private Map<String, String> params = Maps.newHashMap();
        private Map<String, Object> params1 = Maps.newHashMap();

        private RequestWrapper(WSRequest request) {
            this.request = request;
        }

        public RequestWrapper addQueryParameter(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public RequestWrapper addQueryParameter1(String name, Object value) {
            this.params1.put(name, value);
            return this;
        }

        public <R> CompletionStage<R> get(Function<WSResponse, R> function) {
            this.params.forEach((key, value) -> this.request.addQueryParameter(key, value));
            return this.request.get().thenApply(response -> this.processResponse(function, (WSResponse)response));
        }

        public <R> CompletionStage<R> postUrlencoded(Function<WSResponse, R> function) {
            String paramString = StreamEx.of(this.params.entrySet()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).joining((CharSequence)"&");
            this.request = this.request.setContentType("application/x-www-form-urlencoded; charset=utf-8");
            return this.post(() -> paramString, function);
        }

        public <R> CompletionStage<R> post(Supplier<String> supplier, Function<WSResponse, R> function) {
            return this.request.post(supplier.get()).thenApply(response -> this.processResponse(function, (WSResponse)response));
        }

        public <R> CompletionStage<R> post(Function<WSResponse, R> function) {
            return this.post(() -> "", function);
        }

        private <R> R processResponse(Function<WSResponse, R> function, WSResponse response) {
            if (response.getStatus() != 200) {
                throw new WarningException("Status " + response.getStatus(), 1);
            }
            return function.apply(response);
        }

        public <R> CompletionStage<R> put(Function<WSResponse, R> function) {
            this.request = this.request.setContentType("application/json; charset=utf-8");
            Gson gson = new Gson();
            return this.request.put(gson.toJson(this.params1)).thenApply(wsResponse -> this.processResponse(function, (WSResponse)wsResponse));
        }
    }
}

