/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.ImmutablePair;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IShopProtoGateway;
import ru.quadcom.prototool.gateway.messages.sts.shop.BuyOperatorMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.GetOperatorsOnSaleMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.PriceListMessage;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.shopproto.RQ_ShopBuy;
import ru.quadcom.tactics.shopproto.RQ_ShopBuyOperator;
import ru.quadcom.tactics.shopproto.RQ_ShopGetOperatorsOnSale;
import ru.quadcom.tactics.shopproto.RQ_ShopPriceList;
import ru.quadcom.tactics.shopproto.RQ_ShopSell;
import ru.quadcom.tactics.shopproto.RS_ShopBuy;
import ru.quadcom.tactics.shopproto.RS_ShopBuyOperator;
import ru.quadcom.tactics.shopproto.RS_ShopGetOperatorsOnSale;
import ru.quadcom.tactics.shopproto.RS_ShopPriceList;
import ru.quadcom.tactics.shopproto.RS_ShopSell;
import ru.quadcom.tactics.typeproto.ShopType;

public abstract class AbstractShopProtoGateway
extends AbstractProtoGateway
implements IShopProtoGateway {
    public AbstractShopProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<PriceListMessage> priceList(Profile profile) {
        RQ_ShopPriceList request = RQ_ShopPriceList.newBuilder().setProfile(Transformer.toProto(profile)).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_PRICE_LIST, Packet.PacketType.RS_SHOP_PRICE_LIST, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopPriceList.parseFrom((ByteString)bytes))).thenApply(message -> new PriceListMessage(message.getCommonPriceListMap(), message.getSpecialPriceListMap(), message.getRefreshInterval()));
    }

    @Override
    public CompletionStage<Long> buy(Profile profile, ru.quadcom.datapack.domains.shop.ShopType shopType, int itemTemplateId) {
        RQ_ShopBuy request = RQ_ShopBuy.newBuilder().setProfile(Transformer.toProto(profile)).setItemTemplateId(itemTemplateId).setShopType(ShopType.valueOf((String)shopType.name())).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_BUY, Packet.PacketType.RS_SHOP_BUY, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopBuy.parseFrom((ByteString)bytes))).thenApply(RS_ShopBuy::getChangeCash);
    }

    @Override
    public CompletionStage<Long> sell(Profile profile, int itemId) {
        RQ_ShopSell request = RQ_ShopSell.newBuilder().setProfile(Transformer.toProto(profile)).setItemId((long)itemId).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_SELL, Packet.PacketType.RS_SHOP_SELL, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopSell.parseFrom((ByteString)bytes))).thenApply(RS_ShopSell::getChangeCash);
    }

    @Override
    public CompletionStage<GetOperatorsOnSaleMessage> getOperatorsOnSale(Profile profile) {
        RQ_ShopGetOperatorsOnSale request = RQ_ShopGetOperatorsOnSale.newBuilder().setProfile(Transformer.toProto(profile)).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_GET_OPERATORS_ONSALE, Packet.PacketType.RS_SHOP_GET_OPERATORS_ONSALE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopGetOperatorsOnSale.parseFrom((ByteString)bytes))).thenApply(response -> new GetOperatorsOnSaleMessage(StreamEx.of((Collection)response.getShopOperatorList()).map(shopOperator -> ImmutablePair.of((Object)Transformer.fromProto(shopOperator.getOperator()), (Object)shopOperator.getPrice())).toList(), response.getRefreshInterval()));
    }

    @Override
    public CompletionStage<BuyOperatorMessage> buyOperator(Profile profile, long operatorId) {
        RQ_ShopBuyOperator request = RQ_ShopBuyOperator.newBuilder().setProfile(Transformer.toProto(profile)).setOperatorId(operatorId).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_BUY_OPERATOR, Packet.PacketType.RS_SHOP_BUY_OPERATOR, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopBuyOperator.parseFrom((ByteString)bytes))).thenApply(response -> new BuyOperatorMessage(Transformer.fromProto(response.getOperator()), response.getChangeCash()));
    }
}

