/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.protobuf.InvalidProtocolBufferException;
import com.typesafe.config.Config;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import ru.quadcom.commons.exceptions.GatewayException;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.tactics.baseproto.Packet;

@Singleton
public class OpenleadGateway
implements IOpenleadGateway {
    private final WSClient wsClient;
    private final String url;
    private final String api_key;

    @Inject
    public OpenleadGateway(WSClient wsClient, Config config) {
        this.wsClient = wsClient;
        this.url = config.getString("configuration.Openlead_Url");
        this.api_key = config.getString("configuration.Openlead_Api_key");
    }

    @Override
    public void sendData(String user_id, String event, String requestMessage) {
        WSRequest wsRequest = this.wsClient.url(this.url);
        wsRequest.addQueryParameter("api_key", this.api_key);
        wsRequest.addQueryParameter("user_id", user_id);
        wsRequest.addQueryParameter("time", System.currentTimeMillis() / 1000L + "");
        wsRequest.addQueryParameter("event", event);
        wsRequest.addQueryParameter("value", requestMessage);
        wsRequest.post("content").thenApply(wsResponse -> {
            if (wsResponse.getStatus() != 200) {
                throw new GatewayException(wsResponse.getStatus());
            }
            try {
                Packet response = Packet.parseFrom((byte[])wsResponse.getBodyAsBytes().toArray());
                return response.getBody();
            }
            catch (InvalidProtocolBufferException e) {
                throw new WarningException("error parse request", 1);
            }
        });
    }

    private String getToken() {
        return "";
    }
}

