/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.messages.sts.common;

import com.google.common.collect.Maps;
import java.util.Map;
import ru.quadcom.datapack.domains.battleeffects.BattleEffectType;

public class BattleBPInfo {
    private int killCount;
    private final Map<Integer, Integer> classFatality = Maps.newHashMap();
    private final Map<Integer, Integer> skillFatality = Maps.newHashMap();
    private final Map<String, Integer> effectFatality = Maps.newHashMap();
    private final Map<Integer, Integer> huntFatality = Maps.newHashMap();
    private int scanArtefact;

    public void addKillCount(int count) {
        this.killCount += count;
    }

    public void addClassFatality(int classId, int count) {
        this.classFatality.compute(classId, (key, old) -> {
            if (old != null) {
                return old + count;
            }
            return count;
        });
    }

    public void addSkillFatality(int skillId, int count) {
        this.skillFatality.compute(skillId, (key, old) -> {
            if (old != null) {
                return old + count;
            }
            return count;
        });
    }

    public void addEffectFatality(BattleEffectType type, int count) {
        this.effectFatality.compute(type.name(), (key, old) -> {
            if (old != null) {
                return old + count;
            }
            return count;
        });
    }

    public void addHuntFatality(int classId, int count) {
        this.huntFatality.compute(classId, (key, old) -> {
            if (old != null) {
                return old + count;
            }
            return count;
        });
    }

    public void addScanArtefact(int count) {
        this.scanArtefact += count;
    }

    public int getKillCount() {
        return this.killCount;
    }

    public Map<Integer, Integer> getClassFatality() {
        return this.classFatality;
    }

    public Map<Integer, Integer> getSkillFatality() {
        return this.skillFatality;
    }

    public Map<String, Integer> getEffectFatality() {
        return this.effectFatality;
    }

    public Map<Integer, Integer> getHuntFatality() {
        return this.huntFatality;
    }

    public int getScanArtefact() {
        return this.scanArtefact;
    }
}

