/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletionStage;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import ru.quadcom.exceptions.ErrorException;
import ru.quadcom.exceptions.FatalErrorException;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.ThrowableSupplier;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.baseproto.RS_Error;
import ru.quadcom.tactics.baseproto.RS_FatalError;
import ru.quadcom.tactics.baseproto.RS_Warning;

public abstract class AbstractProtoGateway {
    private final WSClient wsClient;
    private final String url;

    public AbstractProtoGateway(WSClient wsClient, String url) {
        this.wsClient = wsClient;
        this.url = url;
    }

    protected CompletionStage<ByteString> sendProto(Packet.PacketType requestType, Packet.PacketType responseType, GeneratedMessageV3 requestMessage, boolean withToken) {
        return this.sendProto(null, requestType, responseType, requestMessage, withToken);
    }

    protected CompletionStage<ByteString> sendProto(String session, Packet.PacketType requestType, Packet.PacketType responseType, GeneratedMessageV3 requestMessage, boolean withToken) {
        return this.sendProtoGetResponse(session, requestType, responseType, requestMessage, withToken).thenApply(Packet::getBody);
    }

    protected CompletionStage<Packet> sendProtoGetResponse(Packet.PacketType requestType, Packet.PacketType responseType, GeneratedMessageV3 requestMessage, boolean withToken) {
        return this.sendProtoGetResponse(null, requestType, responseType, requestMessage, withToken);
    }

    protected CompletionStage<Packet> sendProtoGetResponse(String session, Packet.PacketType requestType, Packet.PacketType responseType, GeneratedMessageV3 requestMessage, boolean withToken) {
        WSRequest wsRequest = this.wsClient.url(this.url);
        if (withToken) {
            wsRequest.addHeader("X-Service-Access-Token", this.getToken());
        }
        wsRequest.addHeader("X-Access-Token", Strings.nullToEmpty((String)session));
        Packet request = Packet.newBuilder().setType(requestType).setBody(requestMessage.toByteString()).build();
        return this.send(wsRequest, request, responseType);
    }

    private CompletionStage<Packet> send(WSRequest wsRequest, Packet request, Packet.PacketType responseType) {
        return wsRequest.setRequestTimeout(Duration.of(30L, ChronoUnit.SECONDS)).post((BodyWritable)ProtoBodyWrapper.of((GeneratedMessageV3)request)).thenApply(wsResponse -> {
            if (wsResponse.getStatus() != 200) {
                throw new WarningException("Status " + wsResponse.getStatus() + " url = " + this.url, 1);
            }
            try {
                Packet response = Packet.parseFrom((byte[])wsResponse.getBodyAsBytes().toArray());
                if (response.getType() == Packet.PacketType.RS_WARNING) {
                    RS_Warning warning = RS_Warning.parseFrom((ByteString)response.getBody());
                    throw new WarningException(warning.getMessage(), warning.getType().getNumber());
                }
                if (response.getType() == Packet.PacketType.RS_ERROR) {
                    RS_Error error = RS_Error.parseFrom((ByteString)response.getBody());
                    throw new ErrorException(error.getMessage(), error.getId());
                }
                if (response.getType() == Packet.PacketType.RS_FATAL_ERROR) {
                    RS_FatalError fatalError = RS_FatalError.parseFrom((ByteString)response.getBody());
                    throw new FatalErrorException(fatalError.getMessage());
                }
                if (response.getType() != responseType) {
                    throw new WarningException("Incorrect type request", 2);
                }
                return response;
            }
            catch (InvalidProtocolBufferException e) {
                throw new WarningException("Error parse request", 1);
            }
        });
    }

    protected abstract String getToken();

    protected <T> T parse(ThrowableSupplier<T, InvalidProtocolBufferException> parser) {
        try {
            return parser.get();
        }
        catch (InvalidProtocolBufferException e) {
            throw new WarningException("Error parse proto", 1);
        }
    }

    private static class ProtoBodyWrapper
    extends InMemoryBodyWritable {
        private ProtoBodyWrapper(GeneratedMessageV3 message) {
            super(akka.util.ByteString.fromArray((byte[])message.toByteArray()), "application/json");
        }

        private static ProtoBodyWrapper of(GeneratedMessageV3 message) {
            return new ProtoBodyWrapper(message);
        }
    }
}

