/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import ru.quadcom.exceptions.ErrorException;

public abstract class AbstractHttpGateway {
    private final WSClient wsClient;
    private final String url;
    private static final Gson gson = new Gson();

    public AbstractHttpGateway(String url, WSClient wsClient) {
        this.wsClient = wsClient;
        this.url = url;
    }

    protected RequestWrapper getRequest(String path, boolean withToken) {
        WSRequest request = this.wsClient.url(this.url + path);
        if (withToken) {
            request.addHeader("X-Service-Access-Token", this.getToken());
        }
        return new RequestWrapper(request);
    }

    protected RequestWrapper getUrlRequest(String url, boolean withToken) {
        WSRequest request = this.wsClient.url(url);
        if (withToken) {
            request.addHeader("X-Service-Access-Token", this.getToken());
        }
        return new RequestWrapper(request);
    }

    protected abstract String getToken();

    public static CompletionStage<WSResponse> makePostWwwFormUrlencoded(WSRequest request, Map<String, String> paramsMap) {
        return AbstractHttpGateway.makePostWwwFormUrlencoded(request, paramsMap, null);
    }

    public static CompletionStage<WSResponse> makePostWwwFormUrlencoded(WSRequest request, Map<String, String> paramsMap, Map<String, String> headers) {
        String paramString = StreamEx.of(paramsMap.entrySet()).map(entry -> {
            try {
                return URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }).joining((CharSequence)"&");
        request.setContentType("application/x-www-form-urlencoded; charset=utf-8");
        if (headers != null) {
            headers.forEach((key, value) -> request.addHeader(key, value));
        }
        return request.post(paramString);
    }

    protected static class RequestWrapper {
        private WSRequest request;
        private Map<String, String> params = Maps.newHashMap();

        private RequestWrapper(WSRequest request) {
            this.request = request;
        }

        public RequestWrapper addQueryParameter(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public <R> CompletionStage<R> get(Function<WSResponse, R> function) {
            this.params.forEach((key, value) -> this.request.addQueryParameter(key, value));
            return this.request.get().thenApply(response -> this.processResponse(function, (WSResponse)response));
        }

        public <R> CompletionStage<R> postUrlencoded(Function<WSResponse, R> function) {
            return AbstractHttpGateway.makePostWwwFormUrlencoded(this.request, this.params).thenApply(response -> this.processResponse(function, (WSResponse)response));
        }

        public <R> CompletionStage<R> postJsonBodyContentTypePlain(String body, Function<WSResponse, R> function) {
            this.request.setContentType("text/plain; charset=utf-8");
            return this.request.post(body).thenApply(wsResponse -> this.processResponse(function, (WSResponse)wsResponse));
        }

        private <R> R processResponse(Function<WSResponse, R> function, WSResponse response) {
            if (response.getStatus() != 200) {
                throw new ErrorException("Url " + this.request.getUrl() + "| Params " + gson.toJson((Object)this.request.getQueryParameters()) + " | Status " + response.getStatus());
            }
            return function.apply(response);
        }
    }
}

