/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.messages.sts.sts;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.operator.Operator;
import ru.quadcom.datapack.templates.common.CurrencyType;
import ru.quadcom.prototool.gateway.messages.sts.AbstractSTSMessage;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.squadproto.RS_FinishBattle;

public class FinishBattleMessage
extends AbstractSTSMessage {
    private final long moneyReward;
    private final List<Item> itemReward = Lists.newArrayList();
    private final Map<CurrencyType, Long> currency;
    private final Map<Integer, Long> items;
    private final int intel;
    private final List<Operator> operatorList;

    public FinishBattleMessage(RS_FinishBattle rs_finishBattle) {
        this.moneyReward = 0L;
        this.items = rs_finishBattle.getItemMap();
        this.currency = rs_finishBattle.getCurrencyMap().entrySet().stream().collect(Collectors.toMap(e -> CurrencyType.valueOf((String)((String)e.getKey())), Map.Entry::getValue));
        this.intel = rs_finishBattle.getIntel();
        this.operatorList = rs_finishBattle.getOperatorList().stream().map(Transformer::fromProto).collect(Collectors.toList());
    }

    public List<Operator> getOperatorList() {
        return this.operatorList;
    }

    public long getMoneyReward() {
        return this.moneyReward;
    }

    public List<Item> getItemReward() {
        return this.itemReward;
    }

    public Map<CurrencyType, Long> getCurrency() {
        return this.currency;
    }

    public Map<Integer, Long> getItems() {
        return this.items;
    }

    public int getIntel() {
        return this.intel;
    }
}

