/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IProfileProtoGateway;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.profileproto.RQ_ProfileChangeCash;
import ru.quadcom.tactics.profileproto.RQ_ProfileCreate;
import ru.quadcom.tactics.profileproto.RQ_ProfileGet;
import ru.quadcom.tactics.profileproto.RQ_ProfileGetAll;
import ru.quadcom.tactics.profileproto.RQ_ProfileUpdateAvatar;
import ru.quadcom.tactics.profileproto.RS_ProfileChangeCash;
import ru.quadcom.tactics.profileproto.RS_ProfileCreate;
import ru.quadcom.tactics.profileproto.RS_ProfileGet;
import ru.quadcom.tactics.profileproto.RS_ProfileGetAll;
import ru.quadcom.tactics.profileproto.RS_ProfileUpdateAvatar;

public abstract class AbstractProfileProtoGateway
extends AbstractProtoGateway
implements IProfileProtoGateway {
    public AbstractProfileProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<Profile> create(long accountId, String nickname, String avatar, int fractionId) {
        RQ_ProfileCreate request = RQ_ProfileCreate.newBuilder().setAccountId(accountId).setNickname(nickname).setAvatar(avatar).setFractionId(fractionId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CREATE, Packet.PacketType.RS_PROFILE_CREATE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileCreate.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getProfile()));
    }

    @Override
    public CompletionStage<List<Profile>> getAll(long accountId) {
        RQ_ProfileGetAll request = RQ_ProfileGetAll.newBuilder().setAccountId(accountId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_GET_ALL, Packet.PacketType.RS_PROFILE_GET_ALL, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileGetAll.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getProfileList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<Profile> updateAvatar(long accountId, long profileId, String avatar) {
        RQ_ProfileUpdateAvatar request = RQ_ProfileUpdateAvatar.newBuilder().setAccountId(accountId).setProfileId(profileId).setAvatar(avatar).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_UPDATE_AVATAR, Packet.PacketType.RS_PROFILE_UPDATE_AVATAR, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileUpdateAvatar.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getProfile()));
    }

    @Override
    public CompletionStage<Optional<Profile>> get(long accountId, long profileId) {
        RQ_ProfileGet request = RQ_ProfileGet.newBuilder().setAccountId(accountId).setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_GET, Packet.PacketType.RS_PROFILE_GET, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileGet.parseFrom((ByteString)bytes))).thenApply(message -> message.hasProfile() ? Optional.of(Transformer.fromProto(message.getProfile())) : Optional.empty());
    }

    @Override
    public CompletionStage<Profile> changeCash(long accountId, long profileId, long changeCash) {
        RQ_ProfileChangeCash request = RQ_ProfileChangeCash.newBuilder().setAccountId(accountId).setProfileId(profileId).setChangeCash(changeCash).build();
        return this.sendProto(Packet.PacketType.RQ_PROFILE_CHANGE_CAHS, Packet.PacketType.RS_PROFILE_CHANGE_CAHS, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ProfileChangeCash.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getProfile()));
    }
}

