/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.concurrent.CompletionStage;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.IProfileServiceGateway;
import ru.quadcom.prototool.gateway.messages.sts.profile.ChangeCashMessage;
import ru.quadcom.prototool.gateway.messages.sts.profile.CreateProfileMessage;
import ru.quadcom.prototool.gateway.messages.sts.profile.ProfileMessage;
import ru.quadcom.prototool.gateway.messages.sts.profile.ProfilesMessage;
import ru.quadcom.prototool.gateway.messages.sts.profile.UpdateAvatarMessage;

public abstract class AbstractProfileServiceGateway
extends AbstractHttpGateway
implements IProfileServiceGateway {
    private static final Gson gson = new GsonBuilder().create();

    public AbstractProfileServiceGateway(String url, WSClient wsClient) {
        super(url, wsClient);
    }

    @Override
    public CompletionStage<ProfileMessage> getProfile(long profileId) {
        return this.getRequest("/profilesevice/sts/1.0/get", false).addQueryParameter("profileId", String.valueOf(profileId)).postUrlencoded(response -> (ProfileMessage)gson.fromJson(response.getBody(), ProfileMessage.class));
    }

    @Override
    public CompletionStage<ChangeCashMessage> changeCash(long profileId, int changeCash) {
        return this.getRequest("/profilesevice/sts/1.0/changeCash", false).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("changeCash", String.valueOf(changeCash)).postUrlencoded(response -> (ChangeCashMessage)gson.fromJson(response.getBody(), ChangeCashMessage.class));
    }

    @Override
    public CompletionStage<UpdateAvatarMessage> updateAvatar(long profileId, String avatar) {
        return this.getRequest("/profilesevice/sts/1.0/updateAvatar", false).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("avatar", avatar).postUrlencoded(response -> (UpdateAvatarMessage)gson.fromJson(response.getBody(), UpdateAvatarMessage.class));
    }

    @Override
    public CompletionStage<ProfilesMessage> getProfiles(long accountId) {
        return this.getRequest("/profilesevice/sts/1.0/getAll", false).addQueryParameter("accountId", String.valueOf(accountId)).postUrlencoded(response -> (ProfilesMessage)gson.fromJson(response.getBody(), ProfilesMessage.class));
    }

    @Override
    public CompletionStage<CreateProfileMessage> createProfile(long accountId, String nickname, String avatar, int fractionId) {
        return this.getRequest("/profilesevice/sts/1.0/create", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("nickname", nickname).addQueryParameter("avatar", avatar).addQueryParameter("fractionId", String.valueOf(fractionId)).postUrlencoded(response -> (CreateProfileMessage)gson.fromJson(response.getBody(), CreateProfileMessage.class));
    }
}

