/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway;

import akka.util.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.CompletionStage;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import ru.quadcom.commons.exceptions.GatewayException;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.exceptions.ErrorException;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.ThrowableSupplier;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.baseproto.RS_Error;
import ru.quadcom.tactics.baseproto.RS_Warning;

public abstract class AbstractProtoGateway {
    private final WSClient wsClient;
    private final String url;

    public AbstractProtoGateway(WSClient wsClient, String url) {
        this.wsClient = wsClient;
        this.url = url;
    }

    protected CompletionStage<com.google.protobuf.ByteString> sendProto(Packet.PacketType requestType, Packet.PacketType responseType, GeneratedMessageV3 requestMessage, boolean withToken) {
        WSRequest wsRequest = this.wsClient.url(this.url);
        if (withToken) {
            wsRequest.addHeader("X-Service-Access-Token", this.getToken());
        }
        Packet request = Packet.newBuilder().setType(requestType).setBody(requestMessage.toByteString()).build();
        return wsRequest.post((BodyWritable)ProtoBodyWrapper.of((GeneratedMessageV3)request)).thenApply(wsResponse -> {
            if (wsResponse.getStatus() != 200) {
                throw new GatewayException(wsResponse.getStatus());
            }
            try {
                Packet response = Packet.parseFrom((byte[])wsResponse.getBodyAsBytes().toArray());
                if (response.getType() == Packet.PacketType.RS_WARNING) {
                    RS_Warning warning = RS_Warning.parseFrom((com.google.protobuf.ByteString)response.getBody());
                    throw new WarningException(warning.getMessage(), warning.getType().getNumber());
                }
                if (response.getType() == Packet.PacketType.RS_ERROR) {
                    RS_Error error = RS_Error.parseFrom((com.google.protobuf.ByteString)response.getBody());
                    throw new ErrorException(error.getMessage(), error.getId());
                }
                if (response.getType() != responseType) {
                    throw new ErrorException("incorrect type request");
                }
                return response.getBody();
            }
            catch (InvalidProtocolBufferException e) {
                throw new ErrorException("error parse request");
            }
        });
    }

    protected abstract String getToken();

    protected <T> T parse(ThrowableSupplier<T, InvalidProtocolBufferException> parser) {
        try {
            return parser.get();
        }
        catch (InvalidProtocolBufferException e) {
            throw new ServiceException("Error parse proto", (Throwable)e, null);
        }
    }

    private static class ProtoBodyWrapper
    extends InMemoryBodyWritable {
        private ProtoBodyWrapper(GeneratedMessageV3 message) {
            super(ByteString.fromArray((byte[])message.toByteArray()), "application/json");
        }

        private static ProtoBodyWrapper of(GeneratedMessageV3 message) {
            return new ProtoBodyWrapper(message);
        }
    }
}

