/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool;

import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import play.mvc.Http;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.prototool.ProtoHandler;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.baseproto.PacketType;

public abstract class AbstractProtoService {
    private final Map<PacketType, Pair<PacketType, ProtoHandler>> map = Maps.newHashMap();

    protected void registrateHandler(PacketType requestType, PacketType responsetype, ProtoHandler handler) {
        this.map.put(requestType, (Pair<PacketType, ProtoHandler>)ImmutablePair.of((Object)responsetype, (Object)handler));
    }

    public CompletionStage<byte[]> handleRequest(Http.RequestBody body) {
        try {
            Packet request = Packet.parseFrom((byte[])body.asBytes().toArray());
            Pair<PacketType, ProtoHandler> pair = this.map.get(request.getType());
            return ((ProtoHandler)pair.getValue()).process0(request.getBody()).thenApply(response -> Packet.newBuilder().setType((PacketType)pair.getKey()).setBody(((GeneratedMessageV3)response).toByteString()).build().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ServiceException("Proto handled error", (Throwable)e, null);
        }
    }
}

