/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import ru.quadcom.commons.exceptions.GatewayException;

public abstract class AbstractServiceGateway {
    private final WSClient wsClient;
    private final String url;

    public AbstractServiceGateway(WSClient wsClient, String url) {
        this.wsClient = wsClient;
        this.url = url;
    }

    protected RequestWrapper getRequest(String path, boolean withToken) {
        WSRequest request = this.wsClient.url(this.url + path);
        if (withToken) {
            request.addHeader("X-Service-Access-Token", this.getToken());
        }
        return new RequestWrapper(request);
    }

    protected abstract String getToken();

    protected static class RequestWrapper {
        private WSRequest request;

        private RequestWrapper(WSRequest request) {
            this.request = request;
        }

        public RequestWrapper addQueryParameter(String name, String value) {
            this.request.addQueryParameter(name, value);
            return this;
        }

        public <R> CompletionStage<R> get(Function<WSResponse, R> function) {
            return this.request.get().thenApply(response -> {
                if (response.getStatus() != 200) {
                    throw new GatewayException(response.getStatus());
                }
                return function.apply((WSResponse)response);
            });
        }
    }
}

