/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway;

import akka.util.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.concurrent.CompletionStage;
import play.libs.ws.BodyWritable;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import ru.quadcom.commons.exceptions.GatewayException;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.service.to.service.ServicesSecrets;
import ru.quadcom.prototool.ThrowableSupplier;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.baseproto.PacketType;

public abstract class ProtoGateway {
    private final WSClient wsClient;
    private final String url;
    private final ServicesSecrets clientSecret;

    public ProtoGateway(WSClient wsClient, String url, ServicesSecrets clientSecret) {
        this.wsClient = wsClient;
        this.url = url;
        this.clientSecret = clientSecret;
    }

    protected CompletionStage<com.google.protobuf.ByteString> sendProto(PacketType type, GeneratedMessageV3 message) {
        WSRequest wsRequest = this.wsClient.url(this.url);
        if (this.getToken() != null) {
            wsRequest.addHeader("X-Service-Access-Token", this.getToken());
        }
        Packet packet = Packet.newBuilder().setType(type).setBody(message.toByteString()).build();
        return wsRequest.post((BodyWritable)ProtoBodyWrapper.of((GeneratedMessageV3)packet)).thenApply(wsResponse -> {
            if (wsResponse.getStatus() != 200) {
                throw new GatewayException(wsResponse.getStatus());
            }
            try {
                Packet request = Packet.parseFrom((byte[])wsResponse.getBodyAsBytes().toArray());
                return request.getBody();
            }
            catch (InvalidProtocolBufferException e) {
                throw new ServiceException("error parse request", (Throwable)e, null);
            }
        });
    }

    protected abstract ServicesSecrets getServerSecret();

    private String getToken() {
        if (this.clientSecret == null || this.getServerSecret() == null) {
            return null;
        }
        ServiceToServiceToken token = ServiceToServiceToken.createAccessToken((ServicesSecrets)this.getServerSecret());
        return token.encode(this.clientSecret);
    }

    protected <T> T parse(ThrowableSupplier<T, InvalidProtocolBufferException> parser) {
        try {
            return parser.get();
        }
        catch (InvalidProtocolBufferException e) {
            throw new ServiceException("Error parse proto", (Throwable)e, null);
        }
    }

    private static class ProtoBodyWrapper
    extends InMemoryBodyWritable {
        private ProtoBodyWrapper(GeneratedMessageV3 message) {
            super(ByteString.fromArray((byte[])message.toByteString().toByteArray()), "application/x-google-protobuf");
        }

        private static ProtoBodyWrapper of(GeneratedMessageV3 message) {
            return new ProtoBodyWrapper(message);
        }
    }
}

