/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import java.util.concurrent.CompletionStage;
import play.libs.Json;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import ru.quadcom.commons.exceptions.GatewayException;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.service.to.service.ServicesSecrets;
import ru.quadcom.gateways.IConfigServiceGateway;

@Singleton
public class ConfigServiceGateway
implements IConfigServiceGateway {
    private final String configurationURL;
    private final WSClient wsClient;

    @Inject
    public ConfigServiceGateway(Config config, WSClient wsClient) {
        this.configurationURL = config.getString("configuration.url");
        this.wsClient = wsClient;
    }

    @Override
    public CompletionStage<String> getServiceUrl() {
        WSRequest request = this.wsClient.url(String.format("%s/configuration/find", this.configurationURL));
        request = request.addHeader("X-Service-Access-Token", ConfigServiceGateway.getConfigurationToken());
        request = request.addQueryParameter("app_name", "X-Tactics");
        request = request.addQueryParameter("env_name", "Develop");
        request = request.addQueryParameter("name_start", "service.STATIC");
        return request.get().thenApply(response -> {
            if (response.getStatus() != 200) {
                throw new GatewayException(response.getStatus());
            }
            String protocol = "";
            String host = "";
            String port = "";
            JsonNode node = Json.parse((String)response.getBody());
            for (JsonNode jsonNode : node) {
                String name;
                switch (name = jsonNode.get("name").asText()) {
                    case "service.STATIC.protocol": {
                        protocol = jsonNode.get("value").asText();
                        break;
                    }
                    case "service.STATIC.port": {
                        port = jsonNode.get("value").asText();
                        break;
                    }
                    case "service.STATIC.host": {
                        host = jsonNode.get("value").asText();
                    }
                }
            }
            return host + ":" + port;
        });
    }

    private static String getConfigurationToken() {
        ServiceToServiceToken token = ServiceToServiceToken.createAccessToken((ServicesSecrets)ServicesSecrets.PROFILE);
        return token.encode(ServicesSecrets.CONFIGURATION);
    }
}

