/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.filehasher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class Hasher
extends TimerTask {
    private final String mapFileName;
    private final String rootFileName;
    private static final String CRC_EXT = ".crc";

    public Hasher(Properties properties) {
        this.rootFileName = properties.getProperty("path");
        this.mapFileName = properties.getProperty("hashfile", "hash.map");
    }

    @Override
    public void run() {
        block29: {
            try {
                Map<Object, Object> lines;
                this.log("Start rehashing");
                File root = new File(this.rootFileName);
                File mapFile = new File(root, this.mapFileName);
                if (!root.exists() && !root.mkdirs()) break block29;
                if (mapFile.exists()) {
                    try (BufferedReader br = Files.newBufferedReader(mapFile.toPath(), StandardCharsets.UTF_8);){
                        lines = br.lines().map(string -> {
                            List splits = Arrays.stream(string.split(",")).map(String::trim).collect(Collectors.toList());
                            if (splits.size() > 3) {
                                return new Line((String)splits.get(0), (String)splits.get(1), (String)splits.get(2), Long.valueOf((String)splits.get(3)));
                            }
                            return null;
                        }).filter(Objects::nonNull).collect(Collectors.toMap(line -> line.path, line -> line, (line1, line2) -> line1));
                        br.close();
                    }
                } else {
                    lines = new HashMap();
                }
                List newLines = Files.walk(Paths.get(this.rootFileName, new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && !path.equals(mapFile.toPath())).map(Path::toFile).filter(file -> !file.getName().endsWith(CRC_EXT)).map(file -> {
                    String path = root.toPath().relativize(file.toPath()).toString();
                    Line line = (Line)lines.get(path);
                    File fileCRC = new File(file.getPath() + CRC_EXT);
                    String hash = this.readLineInFileCRC(fileCRC);
                    long size = file.length();
                    line = line != null ? new Line(line.id, line.path, hash, size) : new Line(file.getName().replaceFirst("\\.[^.]*$", ""), path, hash, size);
                    return line;
                }).collect(Collectors.toList());
                try (BufferedWriter bw = Files.newBufferedWriter(mapFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    for (Line line3 : newLines) {
                        bw.append(String.join((CharSequence)",", line3.id, line3.path, line3.hash, line3.size + "\n"));
                    }
                    bw.flush();
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String readLineInFileCRC(File file) {
        String str = "";
        try (BufferedReader br = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            str = br.readLine();
            br.close();
        }
        catch (Exception e) {
            this.log("Not found crc file " + file.getPath());
        }
        return str;
    }

    private void log(String string) {
        System.out.println(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + ": " + string);
    }

    private static class Line {
        String id;
        String path;
        String hash;
        long size;

        Line(String id, String path, String hash, long size) {
            this.id = id;
            this.path = path;
            this.hash = hash;
            this.size = size;
        }
    }
}

