/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.filehasher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class Hasher
extends TimerTask {
    private final String mapFileName;
    private final String rootFileName;
    private final MessageDigest md;

    public Hasher(Properties properties) throws NoSuchAlgorithmException {
        this.rootFileName = properties.getProperty("path");
        this.mapFileName = properties.getProperty("hashfile", "hash.map");
        this.md = MessageDigest.getInstance("MD5");
    }

    @Override
    public void run() {
        block30: {
            try {
                Map<Object, Object> lines;
                System.out.println(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + " Start rehashing");
                File root = new File(this.rootFileName);
                File mapFile = new File(root, this.mapFileName);
                if (!root.exists() && !root.mkdirs()) break block30;
                if (mapFile.exists()) {
                    try (BufferedReader br = Files.newBufferedReader(mapFile.toPath(), StandardCharsets.UTF_8);){
                        lines = br.lines().map(string -> {
                            List splits = Arrays.stream(string.split(",")).map(String::trim).collect(Collectors.toList());
                            if (splits.size() > 2) {
                                return new Line((String)splits.get(0), (String)splits.get(1), (String)splits.get(2), splits.subList(3, splits.size()));
                            }
                            return null;
                        }).filter(Objects::nonNull).collect(Collectors.toMap(line -> line.path, line -> line, (line1, line2) -> line1));
                        br.close();
                    }
                } else {
                    lines = new HashMap();
                }
                List newLines = Files.walk(Paths.get(this.rootFileName, new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && !path.equals(mapFile.toPath()) && !this.getFileExt(path.getFileName().toString()).equals("crc")).map(Path::toFile).map(file -> {
                    String path = root.toPath().relativize(file.toPath()).toString();
                    Line line = (Line)lines.get(path);
                    String input = file.getName() + ":" + file.length() + ":" + file.lastModified();
                    byte[] md5sum = this.md.digest(input.getBytes());
                    String hash = String.format("%032X", new BigInteger(1, md5sum));
                    line = line != null ? new Line(line.id, line.path, Hasher.readLineInFileCRS(new File(file.getPath() + ".crc").toPath()), new ArrayList<String>(line.params)) : new Line(file.getName().replaceFirst("\\.[^.]*$", ""), path, Hasher.readLineInFileCRS(new File(file.getPath() + ".crc").toPath()), new ArrayList<String>());
                    return line;
                }).collect(Collectors.toList());
                try (BufferedWriter bw = Files.newBufferedWriter(mapFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    for (Line line3 : newLines) {
                        bw.append(String.join((CharSequence)",", line3.id, line3.path, line3.version));
                        if (line3.params.size() > 0) {
                            bw.append(",");
                            bw.append(String.join((CharSequence)",", line3.params));
                        }
                        bw.append("\n");
                    }
                    bw.flush();
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getFileExt(String fileName) {
        String result = "";
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            result = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLineInFileCRS(Path filePath) {
        String str = "";
        try {
            block13: {
                BufferedReader br;
                block14: {
                    br = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        str = br.readLine();
                        br.close();
                        if (br == null) break block13;
                        if (throwable == null) break block14;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (br == null) throw throwable4;
                            if (throwable == null) {
                                br.close();
                                throw throwable4;
                            }
                            try {
                                br.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                br.close();
            }
        }
        catch (Exception exception) {}
        finally {
            return str;
        }
    }

    private static class Line {
        public String id;
        public String path;
        public String version;
        public List<String> params;

        public Line(String id, String path, String version, List<String> params) {
            this.id = id;
            this.path = path;
            this.version = version;
            this.params = params;
        }
    }
}

