/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.loaders.impl.ContractLoader;
import ru.quadcom.datapack.services.IContractPack;
import ru.quadcom.datapack.templates.contract.ContractTemplate;

public class ContractPack
implements IContractPack {
    private final String prefix = "";
    private final Map<Integer, ContractTemplate> contracts;
    private final Map<String, ContractTemplate> contractsByDescriptor;

    public ContractPack(String resourceUrl) {
        this.contracts = new ContractLoader(resourceUrl, "").load("contracts.json");
        this.contractsByDescriptor = StreamEx.of(this.contracts.values()).toMap(ContractTemplate::getDescriptor, Function.identity());
    }

    @Override
    public ContractTemplate getContractTemplate(int contractTemplateId) {
        return this.contracts.get(contractTemplateId);
    }

    @Override
    public ContractTemplate getContractTemplate(String descriptor) {
        return this.contractsByDescriptor.get(descriptor);
    }

    @Override
    public Collection<ContractTemplate> getAll() {
        return Collections.unmodifiableCollection(this.contracts.values());
    }

    @Override
    public Map<Integer, ContractTemplate> getAllAsMap() {
        return Maps.newHashMap(this.contracts);
    }
}

