/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.common.LootDrop;

public class LootDropLoader
extends Loader<LootDrop> {
    public LootDropLoader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<LootDrop>>(){}.getType();
    }

    @Override
    public Map<String, Map<Integer, NavigableMap<Double, ItemType>>> load(String fileName) {
        List lootDrops = StreamEx.of(this.load0(fileName)).toList();
        HashMap map = Maps.newHashMap();
        for (LootDrop lootDrop : lootDrops) {
            map.compute(lootDrop.getDropListName(), (key, value) -> {
                if (value == null) {
                    value = Maps.newHashMap();
                }
                value.compute(lootDrop.getRank(), (key1, value1) -> {
                    if (value1 == null) {
                        double weightSumm = 0.0;
                        value1 = Maps.newTreeMap();
                        value1.putIfAbsent(weightSumm += lootDrop.getWeapon(), ItemType.WEAPON);
                        value1.putIfAbsent(weightSumm += lootDrop.getArmor(), ItemType.ARMOR);
                        value1.putIfAbsent(weightSumm += lootDrop.getGrenade(), ItemType.GRENADE);
                        value1.putIfAbsent(weightSumm += lootDrop.getFirstAid(), ItemType.FIRST_AID);
                        value1.putIfAbsent(weightSumm += lootDrop.getMine(), ItemType.MINE);
                        value1.putIfAbsent(weightSumm += lootDrop.getScanner(), ItemType.SCANNER);
                        value1.putIfAbsent(weightSumm += lootDrop.getGadget(), ItemType.GADGET);
                        value1.putIfAbsent(weightSumm += lootDrop.getAmmo(), ItemType.AMMO);
                        value1.putIfAbsent(weightSumm += lootDrop.getRepairKit(), ItemType.REPAIR_KIT);
                        value1.putIfAbsent(weightSumm += lootDrop.getUpgradeWeapon(), ItemType.UPGRADE_WEAPON);
                        value1.putIfAbsent(weightSumm += lootDrop.getUpgradeArmor(), ItemType.UPGRADE_ARMOR);
                        value1.putIfAbsent(weightSumm += lootDrop.getBox(), ItemType.BOX);
                        value1.putIfAbsent(weightSumm += lootDrop.getKey(), ItemType.KEY);
                        value1.putIfAbsent(weightSumm += lootDrop.getTrash(), ItemType.TRASH);
                        value1.remove(0.0);
                    }
                    return value1;
                });
                return value;
            });
        }
        return map;
    }
}

