/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.templates.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.domains.item.AttachedSlot;
import ru.quadcom.datapack.domains.item.ItemAction;
import ru.quadcom.datapack.domains.item.ItemActionType;
import ru.quadcom.datapack.domains.item.ItemClass;
import ru.quadcom.datapack.domains.item.ItemDefaultProperty;
import ru.quadcom.datapack.domains.item.ItemQuality;
import ru.quadcom.datapack.domains.item.ItemSubClass;
import ru.quadcom.datapack.domains.item.ItemTemplateProperty;
import ru.quadcom.datapack.domains.item.ItemTemplatePropertyName;
import ru.quadcom.datapack.domains.item.ItemType;

public class ItemTemplate {
    private int id;
    private String guid;
    private String descriptor;
    private ItemQuality quality;
    private int durability;
    private int resource;
    private boolean isStackable;
    private ItemType itemType;
    private ItemClass itemClass;
    private ItemSubClass itemSubClass;
    private int minStrength;
    private int minIntelligence;
    private int tier;
    private boolean enabledForNpc;
    private boolean enabledForPlayer;
    private AttachedSlot attachedSlot;
    private List<ItemTemplateProperty> templateProperties;
    private List<ItemDefaultProperty> defaultItemProperties;
    private List<ItemAction> actions;
    private transient Map<ItemActionType, ItemAction> actionsMap;
    private transient Map<ItemTemplatePropertyName, String> templatePropertiesMap;

    public ItemTemplate(int id, String guid, String descriptor, ItemQuality quality, int durability, boolean isStackable, ItemClass itemClass, ItemSubClass itemSubClass, int minStrength, int minIntelligence, int tier, boolean enabledForNpc, boolean enabledForPlayer, AttachedSlot attachedSlot, ItemType itemType, List<ItemTemplateProperty> templateProperties, List<ItemDefaultProperty> defaultItemProperties, List<ItemAction> actions) {
        this.id = id;
        this.guid = guid;
        this.descriptor = descriptor;
        this.quality = quality;
        this.durability = durability;
        this.isStackable = isStackable;
        this.itemClass = itemClass;
        this.itemSubClass = itemSubClass;
        this.minStrength = minStrength;
        this.minIntelligence = minIntelligence;
        this.tier = tier;
        this.enabledForNpc = enabledForNpc;
        this.enabledForPlayer = enabledForPlayer;
        this.templateProperties = templateProperties;
        this.defaultItemProperties = defaultItemProperties;
        this.actions = actions;
        this.attachedSlot = attachedSlot;
        this.itemType = itemType;
    }

    public ItemTemplate(int id, String guid, String descriptor, ItemQuality quality, int durability, int resource, boolean isStackable, ItemClass itemClass, ItemSubClass itemSubClass, int minStrength, int minIntelligence, int tier, boolean enabledForNpc, boolean enabledForPlayer, AttachedSlot attachedSlot, ItemType itemType, List<ItemTemplateProperty> templateProperties, List<ItemDefaultProperty> defaultItemProperties, List<ItemAction> actions) {
        this.id = id;
        this.guid = guid;
        this.descriptor = descriptor;
        this.quality = quality;
        this.durability = durability;
        this.resource = resource;
        this.isStackable = isStackable;
        this.itemClass = itemClass;
        this.itemSubClass = itemSubClass;
        this.minStrength = minStrength;
        this.minIntelligence = minIntelligence;
        this.tier = tier;
        this.enabledForNpc = enabledForNpc;
        this.enabledForPlayer = enabledForPlayer;
        this.templateProperties = templateProperties;
        this.defaultItemProperties = defaultItemProperties;
        this.actions = actions;
        this.attachedSlot = attachedSlot;
        this.itemType = itemType;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public boolean isAttachable() {
        return this.attachedSlot != null;
    }

    public AttachedSlot getAttachedSlot() {
        return this.attachedSlot;
    }

    public int getId() {
        return this.id;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public ItemQuality getQuality() {
        return this.quality;
    }

    public int getDurability() {
        return this.durability;
    }

    public int getResource() {
        return this.resource;
    }

    public boolean isStackable() {
        return this.isStackable;
    }

    public ItemClass getItemClass() {
        return this.itemClass;
    }

    public ItemSubClass getItemSubClass() {
        return this.itemSubClass;
    }

    public int getMinStrength() {
        return this.minStrength;
    }

    public int getMinIntelligence() {
        return this.minIntelligence;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isEnabledForNpc() {
        return this.enabledForNpc;
    }

    public boolean isEnabledForPlayer() {
        return this.enabledForPlayer;
    }

    public List<ItemTemplateProperty> getTemplateProperties() {
        return this.templateProperties;
    }

    public List<ItemDefaultProperty> getDefaultItemProperties() {
        return this.defaultItemProperties;
    }

    public List<ItemAction> getActions() {
        return this.actions;
    }

    public Map<ItemActionType, ItemAction> getActionsMap() {
        return this.actionsMap;
    }

    private Map<ItemTemplatePropertyName, String> getTemplatePropertiesMap() {
        return this.templatePropertiesMap;
    }

    public int getIntItemTemplateProperty(ItemTemplatePropertyName propertyName) {
        if (this.templatePropertiesMap.containsKey((Object)propertyName) && this.templatePropertiesMap.get((Object)propertyName) != null && !this.templatePropertiesMap.get((Object)propertyName).isEmpty()) {
            return Integer.parseInt(this.templatePropertiesMap.get((Object)propertyName));
        }
        return 0;
    }

    public String getStringItemTemplateProperty(ItemTemplatePropertyName propertyName) {
        if (this.templatePropertiesMap.containsKey((Object)propertyName) && this.templatePropertiesMap.get((Object)propertyName) != null) {
            return this.templatePropertiesMap.get((Object)propertyName);
        }
        return "";
    }

    public double getDoubleItemTemplateProperty(ItemTemplatePropertyName propertyName) {
        if (this.templatePropertiesMap.containsKey((Object)propertyName) && this.templatePropertiesMap.get((Object)propertyName) != null && !this.templatePropertiesMap.get((Object)propertyName).isEmpty()) {
            return Double.parseDouble(this.templatePropertiesMap.get((Object)propertyName));
        }
        return 0.0;
    }

    public boolean getBooleanItemTemplateProperty(ItemTemplatePropertyName propertyName) {
        if (this.templatePropertiesMap.containsKey((Object)propertyName) && this.templatePropertiesMap.get((Object)propertyName) != null && !this.templatePropertiesMap.get((Object)propertyName).isEmpty()) {
            return Boolean.parseBoolean(this.templatePropertiesMap.get((Object)propertyName));
        }
        return false;
    }

    public void preProcess() {
        this.actionsMap = new HashMap<ItemActionType, ItemAction>();
        for (ItemAction action : this.actions) {
            action.preProcess();
            this.actionsMap.put(action.getId(), action);
        }
        this.templatePropertiesMap = new HashMap<ItemTemplatePropertyName, String>();
        for (ItemTemplateProperty itemTemplateProperty : this.templateProperties) {
            this.templatePropertiesMap.put(itemTemplateProperty.getName(), itemTemplateProperty.getValue());
        }
    }
}

