/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.operator.NameTemplate;

public class NamesLoader
extends Loader<NameTemplate> {
    public NamesLoader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<NameTemplate>>(){}.getType();
    }

    @Override
    public Map<Integer, Map<Integer, List<NameTemplate>>> load(String fileName) {
        HashMap map = Maps.newHashMap();
        for (NameTemplate nameTemplate : this.load0(fileName)) {
            Map inMap = map.computeIfAbsent(nameTemplate.getNationalityId(), k -> Maps.newHashMap());
            List list = inMap.computeIfAbsent(nameTemplate.getSexId(), k -> Lists.newArrayList());
            list.add(nameTemplate);
        }
        return map;
    }
}

