/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopGroup;

public class ItemSpecialShopGroupLoader
extends Loader<ItemSpecialShopGroup> {
    public ItemSpecialShopGroupLoader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<ItemSpecialShopGroup>>(){}.getType();
    }

    @Override
    public NavigableMap<Integer, NavigableMap<Double, ItemType>> load(String fileName) {
        Map temp = StreamEx.of(this.load0(fileName)).groupingBy(ItemSpecialShopGroup::getAccountLevel);
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry entry : temp.entrySet()) {
            TreeMap mapWeights = Maps.newTreeMap();
            for (ItemSpecialShopGroup issg : (List)entry.getValue()) {
                mapWeights.put(issg.getWeapon(), ItemType.WEAPON);
                mapWeights.put((Double)mapWeights.lastKey() + issg.getArmor(), ItemType.ARMOR);
                mapWeights.put((Double)mapWeights.lastKey() + issg.getGrenade(), ItemType.GRENADE);
                mapWeights.put((Double)mapWeights.lastKey() + issg.getFirstAidKit(), ItemType.FIRST_AID);
                mapWeights.put((Double)mapWeights.lastKey() + issg.getAmmo(), ItemType.AMMO);
                mapWeights.put((Double)mapWeights.lastKey() + issg.getUpgradeWeapon(), ItemType.UPGRADE_WEAPON);
                mapWeights.put((Double)mapWeights.lastKey() + issg.getUpgradeArmor(), ItemType.UPGRADE_ARMOR);
            }
            map.put(entry.getKey(), mapWeights);
        }
        return map;
    }
}

