/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.impl.ItemShopLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopGroupLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopWeightLoader;
import ru.quadcom.datapack.services.IShopPack;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.shop.ItemShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopWeight;

public class ShopPack
implements IShopPack {
    private final String prefix = "";
    private final Map<Integer, Map<Integer, ItemShopTemplate>> itemShop;
    private final Map<Integer, Map<Integer, ItemSpecialShopTemplate>> itemSpecialShop;
    private final NavigableMap<Integer, NavigableMap<Double, ItemType>> itemSpecialShopGroup;
    private final Map<ItemType, NavigableMap<Integer, NavigableMap<Double, ItemSpecialShopWeight>>> itemSpecialShopWeight;

    public ShopPack(String resourceUrl) {
        this.itemShop = StreamEx.of((Collection)new ItemShopLoader(resourceUrl, "").load("item_shop.json")).groupingBy(ItemShopTemplate::getFractionId, Collectors.toMap(ItemShopTemplate::getItemTemplateId, template -> template));
        this.itemSpecialShop = StreamEx.of((Collection)new ItemSpecialShopLoader(resourceUrl, "").load("item_special_shop.json")).groupingBy(ItemSpecialShopTemplate::getFractionId, Collectors.toMap(ItemSpecialShopTemplate::getItemTemplateId, template -> template));
        this.itemSpecialShopGroup = new ItemSpecialShopGroupLoader(resourceUrl, "").load("item_special_shop_group.json");
        this.itemSpecialShopWeight = new ItemSpecialShopWeightLoader(resourceUrl, "").load("item_special_shop_weight.json");
    }

    @Override
    public Map<Integer, ItemShopTemplate> getItemShop(FractionTemplate fractionTemplate) {
        return this.itemShop.get(fractionTemplate.getId());
    }

    @Override
    @Deprecated
    public Map<Integer, ItemSpecialShopTemplate> getItemSpecialShop(FractionTemplate fractionTemplate) {
        return this.itemSpecialShop.get(fractionTemplate.getId());
    }

    @Override
    public int getSpecialShopItem(int level) {
        Map.Entry<Double, ItemSpecialShopWeight> idEntry;
        NavigableMap<Double, ItemSpecialShopWeight> weightsByLevel;
        Map.Entry<Integer, NavigableMap<Double, ItemSpecialShopWeight>> weightsForLevelEntry;
        NavigableMap<Integer, NavigableMap<Double, ItemSpecialShopWeight>> weights;
        ItemType type;
        Map.Entry<Double, ItemType> typeEntry;
        NavigableMap<Double, ItemType> group;
        Map.Entry<Integer, NavigableMap<Double, ItemType>> groupEntry = this.itemSpecialShopGroup.floorEntry(level);
        if (groupEntry != null && (group = groupEntry.getValue()) != null && (typeEntry = group.ceilingEntry(Math.random())) != null && (type = typeEntry.getValue()) != null && (weights = this.itemSpecialShopWeight.get((Object)type)) != null && (weightsForLevelEntry = weights.floorEntry(level)) != null && (weightsByLevel = weightsForLevelEntry.getValue()) != null && (idEntry = weightsByLevel.ceilingEntry(Math.random())) != null) {
            return idEntry.getValue().getItemTemplateId();
        }
        return 0;
    }
}

