/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.loaders.impl.HardPvpGroupsLoader;
import ru.quadcom.datapack.loaders.impl.HardPvpUnitsLoader;
import ru.quadcom.datapack.loaders.impl.NPCConfigLoader;
import ru.quadcom.datapack.loaders.impl.NPCGenerationLoader;
import ru.quadcom.datapack.loaders.impl.NpcLoader;
import ru.quadcom.datapack.services.INPCPack;
import ru.quadcom.datapack.templates.contract.ContractEnemyType;
import ru.quadcom.datapack.templates.contract.ContractNpcDifficulty;
import ru.quadcom.datapack.templates.npc.HardPvpGroupTemplate;
import ru.quadcom.datapack.templates.npc.HardPvpUnitTemplate;
import ru.quadcom.datapack.templates.npc.NPCConfigTemplate;
import ru.quadcom.datapack.templates.npc.NPCGeneration;
import ru.quadcom.datapack.templates.npc.NpcTemplate;

public class NPCPack
implements INPCPack {
    private final String prefix = "";
    private Map<ContractNpcDifficulty, NPCGeneration> npcGeneration;
    private Map<Integer, NpcTemplate> npc;
    private Map<String, List<NpcTemplate>> npcsByMissionId;
    private Map<String, NPCConfigTemplate> npcConfigByDescriptor;
    private Map<Integer, List<NPCConfigTemplate>> npcConfigByFractionId;
    private Map<ContractEnemyType, List<HardPvpGroupTemplate>> hardPvpGroupsByNpcType;
    private Map<String, List<HardPvpUnitTemplate>> hardPvpUnitsByGroupId;

    NPCPack(String resourceUrl) {
        this.npcGeneration = new NPCGenerationLoader(resourceUrl, "").load("npc_generation.json");
        this.npc = new NpcLoader(resourceUrl, "").load("npc.json");
        this.npcConfigByDescriptor = new NPCConfigLoader(resourceUrl, "").load("npc_config.json");
        Object hardPvpGroupByDescriptor = new HardPvpGroupsLoader(resourceUrl, "").load("hardpvp_groups.json");
        Object hardPvpUnitsByDescriptor = new HardPvpUnitsLoader(resourceUrl, "").load("hardpvp_units.json");
        this.npcsByMissionId = new HashMap<String, List<NpcTemplate>>();
        for (NpcTemplate npcTemplate : this.npc.values()) {
            if (!this.npcsByMissionId.containsKey(npcTemplate.getMissionId())) {
                this.npcsByMissionId.put(npcTemplate.getMissionId(), new ArrayList());
            }
            this.npcsByMissionId.get(npcTemplate.getMissionId()).add(npcTemplate);
        }
        this.npcConfigByFractionId = new HashMap<Integer, List<NPCConfigTemplate>>();
        for (NPCConfigTemplate nPCConfigTemplate : this.npcConfigByDescriptor.values()) {
            if (!this.npcConfigByFractionId.containsKey(nPCConfigTemplate.getFractionId())) {
                this.npcConfigByFractionId.put(nPCConfigTemplate.getFractionId(), new ArrayList());
            }
            this.npcConfigByFractionId.get(nPCConfigTemplate.getFractionId()).add(nPCConfigTemplate);
        }
        this.hardPvpGroupsByNpcType = new HashMap<ContractEnemyType, List<HardPvpGroupTemplate>>();
        for (HardPvpGroupTemplate hardPvpGroupTemplate : hardPvpGroupByDescriptor.values()) {
            if (!this.hardPvpGroupsByNpcType.containsKey((Object)hardPvpGroupTemplate.getUnitsType())) {
                this.hardPvpGroupsByNpcType.put(hardPvpGroupTemplate.getUnitsType(), new ArrayList());
            }
            this.hardPvpGroupsByNpcType.get((Object)hardPvpGroupTemplate.getUnitsType()).add(hardPvpGroupTemplate);
        }
        this.hardPvpUnitsByGroupId = new HashMap<String, List<HardPvpUnitTemplate>>();
        for (HardPvpUnitTemplate hardPvpUnitTemplate : hardPvpUnitsByDescriptor.values()) {
            if (!this.hardPvpUnitsByGroupId.containsKey(hardPvpUnitTemplate.getGroupId())) {
                this.hardPvpUnitsByGroupId.put(hardPvpUnitTemplate.getGroupId(), new ArrayList());
            }
            this.hardPvpUnitsByGroupId.get(hardPvpUnitTemplate.getGroupId()).add(hardPvpUnitTemplate);
        }
    }

    @Override
    public NPCGeneration getGeneration(ContractNpcDifficulty difficulty) {
        return this.npcGeneration.get((Object)difficulty);
    }

    @Override
    public NpcTemplate getNpcTemplate(int id) {
        return this.npc.get(id);
    }

    @Override
    public List<NpcTemplate> getNpcTemplatesByMissionId(String missionId) {
        return this.npcsByMissionId.get(missionId);
    }

    @Override
    public NPCConfigTemplate getNpcConfigByDescriptor(String descriptor) {
        return this.npcConfigByDescriptor.get(descriptor);
    }

    @Override
    public List<NPCConfigTemplate> getNpcConfigByFractionId(int fractionId) {
        return this.npcConfigByFractionId.get(fractionId);
    }

    @Override
    public List<HardPvpGroupTemplate> getHardPvpGroupsByType(ContractEnemyType npcType) {
        return this.hardPvpGroupsByNpcType.get((Object)npcType);
    }

    @Override
    public List<HardPvpUnitTemplate> getHardPvpUnitsForGroup(String groupId) {
        return this.hardPvpUnitsByGroupId.get(groupId);
    }
}

