/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopWeight;

public class ItemSpecialShopWeightLoader
extends Loader<ItemSpecialShopWeight> {
    private final int level3 = 3;
    private final int level10 = 10;
    private final int level20 = 20;
    private final int level30 = 30;

    public ItemSpecialShopWeightLoader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<ItemSpecialShopWeight>>(){}.getType();
    }

    @Override
    public Map<ItemType, NavigableMap<Integer, NavigableMap<Double, ItemSpecialShopWeight>>> load(String fileName) {
        Map temp = StreamEx.of(this.load0(fileName)).groupingBy(ItemSpecialShopWeight::getItemType);
        HashMap map = Maps.newHashMap();
        for (ItemType itemType : temp.keySet()) {
            map.put(itemType, Maps.newTreeMap());
        }
        for (Map.Entry entry : temp.entrySet()) {
            NavigableMap weightsByLevel = (NavigableMap)map.get(entry.getKey());
            weightsByLevel.put(3, Maps.newTreeMap());
            weightsByLevel.put(10, Maps.newTreeMap());
            weightsByLevel.put(20, Maps.newTreeMap());
            weightsByLevel.put(30, Maps.newTreeMap());
            for (ItemSpecialShopWeight issw : (List)entry.getValue()) {
                NavigableMap weights3 = (NavigableMap)weightsByLevel.get(3);
                double lastKey = weights3.isEmpty() ? 0.0 : (Double)weights3.lastKey();
                weights3.put(lastKey + (double)issw.getaLevel3(), issw);
                NavigableMap weights10 = (NavigableMap)weightsByLevel.get(10);
                lastKey = weights10.isEmpty() ? 0.0 : (Double)weights10.lastKey();
                weights10.put(lastKey + (double)issw.getaLevel3(), issw);
                NavigableMap weights20 = (NavigableMap)weightsByLevel.get(3);
                lastKey = weights20.isEmpty() ? 0.0 : (Double)weights20.lastKey();
                weights20.put(lastKey + (double)issw.getaLevel3(), issw);
                NavigableMap weights30 = (NavigableMap)weightsByLevel.get(3);
                lastKey = weights30.isEmpty() ? 0.0 : (Double)weights30.lastKey();
                weights30.put(lastKey + (double)issw.getaLevel3(), issw);
            }
        }
        return map;
    }
}

