/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.StatHelper;
import ru.quadcom.datapack.domains.BaseVariable;
import ru.quadcom.datapack.domains.operator.Operator;
import ru.quadcom.datapack.domains.operator.OperatorRarity;
import ru.quadcom.datapack.services.impl.DataPack;
import ru.quadcom.datapack.templates.operator.ClassTemplate;
import ru.quadcom.datapack.templates.operator.RankTemplate;
import ru.quadcom.datapack.templates.operator.RarityTemplate;

public class Main {
    public static void main(String[] args) {
        DataPack s = new DataPack("../X-TacticsServiceData/resources/templates"){};
        Main.test();
        System.out.println("ok");
    }

    private static void test() {
        HashMap map = Maps.newHashMap();
        int count = 100000000;
        int counter = 0;
        int stepCounter = 0;
        int summ = 0;
        for (int i = 0; i < count; ++i) {
            double rand = Math.random();
            double res = 30.0 + 70.0 * rand;
            ++stepCounter;
            if (!(res > 99.0)) continue;
            ++counter;
            summ += stepCounter;
            map.compute(stepCounter, (k, v) -> v == null ? 1 : v + 1);
            stepCounter = 0;
        }
        HashMap persent = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            persent.put(entry.getKey(), (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)count * (double)((Integer)entry.getKey()).intValue());
        }
        double sumPercent = 0.0;
        for (Double d : persent.values()) {
            sumPercent += d.doubleValue();
        }
        System.out.println("all = " + counter + ", mid = " + (double)summ * 1.0 / (double)counter);
        System.out.println(map);
        System.out.println(persent);
        System.out.println(sumPercent);
    }

    private static void levelUp(Operator operator, RankTemplate newRank, DataPack dataPack) {
        for (int i = operator.getRankId(); i < newRank.getLevel(); ++i) {
            operator.setRankId(newRank.getLevel());
            operator.setSkillPoints(operator.getSkillPoints() + 2);
            ((StreamEx)((StreamEx)StreamEx.of((Object[])StatHelper.values()).sorted(Comparator.comparingInt(stat -> stat.getValue(operator)))).limit(2L)).forEach(stat -> stat.changeValue(operator, 2));
            StreamEx.of((Object[])StatHelper.values()).forEach(stat -> stat.changeValue(operator, 1));
            StreamEx.of((Object[])StatHelper.values()).forEach(stat -> stat.setCounter(operator, 0));
            if (i != 3) continue;
            ArrayList addedClasses = Lists.newArrayList();
            RarityTemplate operatorRarity = dataPack.getOperatorPack().getRarity(operator.getRarityId());
            if (Math.random() < operatorRarity.getClassEliteChance()) {
                addedClasses.addAll(Main.findClass(OperatorRarity.RARE, dataPack));
            }
            if (BaseVariable.ALTERNATIVE_CLASS_GENERATION_FOR_ELITE.getInt() <= 0) continue;
            RarityTemplate eliteRarity = dataPack.getOperatorPack().getRarityByName(OperatorRarity.ELITE);
            if (operator.getRarityId() == eliteRarity.getId()) {
                List classes = ((StreamEx)((StreamEx)StreamEx.of(dataPack.getOperatorPack().getClasses()).filter(template -> !template.isBase())).filter(template -> template.getChance() > 0.0)).toList();
                Collections.shuffle(classes);
                if (classes.size() > 0) {
                    addedClasses.add(classes.get(0));
                }
            } else if (Math.random() < operatorRarity.getClassCelebrityChance()) {
                addedClasses.addAll(Main.findClass(OperatorRarity.ELITE, dataPack));
            }
            operator.addClasses(StreamEx.of((Collection)addedClasses).map(ClassTemplate::getId).toList());
        }
    }

    private static List<ClassTemplate> findClass(OperatorRarity operatorRarity, DataPack dataPack) {
        RarityTemplate filterRarity = dataPack.getOperatorPack().getRarityByName(operatorRarity);
        if (filterRarity == null) {
            return Collections.emptyList();
        }
        ClassTemplate clazz = dataPack.getOperatorPack().getNextNotBaseClass(filterRarity);
        return clazz != null ? Lists.newArrayList((Object[])new ClassTemplate[]{clazz}) : Collections.emptyList();
    }
}

