/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.loaders.impl.NPCConfigLoader;
import ru.quadcom.datapack.loaders.impl.NPCGenerationLoader;
import ru.quadcom.datapack.loaders.impl.NpcLoader;
import ru.quadcom.datapack.services.INPCPack;
import ru.quadcom.datapack.templates.contract.ContractNpcDifficulty;
import ru.quadcom.datapack.templates.npc.NPCConfigTemplate;
import ru.quadcom.datapack.templates.npc.NPCGeneration;
import ru.quadcom.datapack.templates.npc.NpcTemplate;

public class NPCPack
implements INPCPack {
    private final String prefix = "";
    private Map<ContractNpcDifficulty, NPCGeneration> npcGeneration;
    private Map<Integer, NpcTemplate> npc;
    private Map<String, List<NpcTemplate>> npcsByMissionId;
    private Map<String, NPCConfigTemplate> npcConfigByDescriptor;
    private Map<Integer, List<NPCConfigTemplate>> npcConfigByFractionId;

    NPCPack(String resourceUrl) {
        this.npcGeneration = new NPCGenerationLoader(resourceUrl, "").load("npc_generation.json");
        this.npc = new NpcLoader(resourceUrl, "").load("npc.json");
        this.npcConfigByDescriptor = new NPCConfigLoader(resourceUrl, "").load("npc_config.json");
        this.npcsByMissionId = new HashMap<String, List<NpcTemplate>>();
        for (NpcTemplate npc : this.npc.values()) {
            if (!this.npcsByMissionId.containsKey(npc.getMissionId())) {
                this.npcsByMissionId.put(npc.getMissionId(), new ArrayList());
            }
            this.npcsByMissionId.get(npc.getMissionId()).add(npc);
        }
        this.npcConfigByFractionId = new HashMap<Integer, List<NPCConfigTemplate>>();
        for (NPCConfigTemplate template : this.npcConfigByDescriptor.values()) {
            if (!this.npcConfigByFractionId.containsKey(template.getFractionId())) {
                this.npcConfigByFractionId.put(template.getFractionId(), new ArrayList());
            }
            this.npcConfigByFractionId.get(template.getFractionId()).add(template);
        }
    }

    @Override
    public NPCGeneration getGeneration(ContractNpcDifficulty difficulty) {
        return this.npcGeneration.get((Object)difficulty);
    }

    @Override
    public NpcTemplate getNpcTemplate(int id) {
        return this.npc.get(id);
    }

    @Override
    public List<NpcTemplate> getNpcTemplatesByMissionId(String missionId) {
        return this.npcsByMissionId.get(missionId);
    }

    @Override
    public NPCConfigTemplate getNpcConfigByDescriptor(String descriptor) {
        return this.npcConfigByDescriptor.get(descriptor);
    }

    @Override
    public List<NPCConfigTemplate> getNpcConfigByFractionId(int fractionId) {
        return this.npcConfigByFractionId.get(fractionId);
    }
}

