/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.EnumUtil;
import ru.quadcom.datapack.domains.MissionResult;
import ru.quadcom.datapack.domains.item.ItemActionType;
import ru.quadcom.datapack.domains.item.ItemClass;
import ru.quadcom.datapack.domains.item.ItemTemplatePropertyName;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.impl.ItemActionsLoader;
import ru.quadcom.datapack.loaders.impl.ItemPropertiesLoader;
import ru.quadcom.datapack.loaders.impl.ItemsLoader;
import ru.quadcom.datapack.loaders.impl.LootDropLoader;
import ru.quadcom.datapack.loaders.impl.LootWeightLoader;
import ru.quadcom.datapack.loaders.impl.MoneyRewardLoader;
import ru.quadcom.datapack.services.IItemPack;
import ru.quadcom.datapack.templates.item.ItemActionTemplate;
import ru.quadcom.datapack.templates.item.ItemPropertyTemplate;
import ru.quadcom.datapack.templates.item.ItemTemplate;
import ru.quadcom.exceptions.ErrorException;

public class ItemPack
implements IItemPack {
    private String prefix = "";
    private Map<Integer, ItemTemplate> itemTemplates;
    private Map<Integer, ItemTemplate> skillTemplates;
    private Map<ItemActionType, ItemActionTemplate> itemActionTemplates;
    private Map<Integer, ItemPropertyTemplate> itemPropertyTemplates;
    private Map<String, Map<Integer, NavigableMap<Double, ItemType>>> lootDrops;
    private Map<ItemType, Map<Integer, NavigableMap<Double, Integer>>> lootWeights;
    private Map<Integer, ItemTemplate> ammo;
    private Map<String, Map<MissionResult, Map<Integer, Integer>>> moneyResults;

    ItemPack(String resourceUrl) {
        this.itemTemplates = new ItemsLoader(resourceUrl, this.prefix).load("items.json");
        this.itemActionTemplates = new ItemActionsLoader(resourceUrl, this.prefix).load("item_actions.json");
        this.itemPropertyTemplates = new ItemPropertiesLoader(resourceUrl, this.prefix).load("item_properties.json");
        this.skillTemplates = new ItemsLoader(resourceUrl, this.prefix).load("skills.json");
        this.lootDrops = new LootDropLoader(resourceUrl, this.prefix).load("loot_drops.json");
        this.lootWeights = new LootWeightLoader(resourceUrl, this.prefix, this.itemTemplates).load("loot_weights.json");
        this.ammo = ((StreamEx)StreamEx.of(this.itemTemplates.values()).filter(template -> template.getItemType() == ItemType.AMMO)).toMap(ItemTemplate::getId, template -> template);
        this.moneyResults = new MoneyRewardLoader(resourceUrl, this.prefix).load("money_rewards.json");
        this.preProcessItemTemplates();
    }

    @Override
    public int getMoneyReward(String rewardName, MissionResult missionResult, int rank) {
        return this.moneyResults.getOrDefault(rewardName, Maps.newHashMap()).getOrDefault((Object)missionResult, Maps.newHashMap()).getOrDefault(rank, 0);
    }

    @Override
    public Optional<ItemTemplate> getDefaultAmmo(ItemTemplate weapon) {
        if (weapon.getItemType() != ItemType.WEAPON) {
            throw new ErrorException("Wrong item type " + (Object)((Object)weapon.getItemType()));
        }
        return ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.ammo.values()).filter(template -> template.getBooleanItemTemplateProperty(ItemTemplatePropertyName.defaultammo))).filter(template -> template.getBooleanItemTemplateProperty(ItemTemplatePropertyName.batterytype) == weapon.getBooleanItemTemplateProperty(ItemTemplatePropertyName.rayweapon))).filter(template -> {
            if (weapon.getBooleanItemTemplateProperty(ItemTemplatePropertyName.rayweapon)) {
                return true;
            }
            String weapontype = template.getStringItemTemplateProperty(ItemTemplatePropertyName.weapontype);
            return Strings.isNullOrEmpty((String)weapontype) || EnumUtil.lookup(ItemClass.class, weapontype) == weapon.getItemClass();
        })).findFirst();
    }

    @Override
    public List<ItemTemplate> getItemTemplates() {
        return Lists.newArrayList(this.itemTemplates.values());
    }

    @Override
    public Optional<ItemTemplate> getItemTemplateOptional(int itemTemplateId) {
        return Optional.ofNullable(this.itemTemplates.get(itemTemplateId));
    }

    @Override
    public ItemTemplate getItemTemplate(int itemTemplateId) {
        ItemTemplate item = this.itemTemplates.get(itemTemplateId);
        if (item == null) {
            throw new ErrorException("ItemTemplate not found, id = " + itemTemplateId);
        }
        return item;
    }

    @Override
    public ItemTemplate getSkillTemplate(int skillTemplateId) {
        ItemTemplate skill = this.skillTemplates.get(skillTemplateId);
        if (skill == null) {
            throw new ErrorException("SkillTemplate not found, id = " + skillTemplateId);
        }
        return skill;
    }

    @Override
    public Optional<ItemTemplate> getSkillTemplateOptional(int skillTemplateId) {
        return Optional.ofNullable(this.skillTemplates.get(skillTemplateId));
    }

    @Override
    public List<ItemTemplate> getSkills() {
        return Lists.newArrayList(this.skillTemplates.values());
    }

    @Override
    public ItemActionTemplate getItemActionTemplate(ItemActionType itemActionType) {
        return this.itemActionTemplates.get((Object)itemActionType);
    }

    @Override
    public ItemPropertyTemplate getItemPropertyTemplate(int itemPropertyTemplateId) {
        return this.itemPropertyTemplates.get(itemPropertyTemplateId);
    }

    @Override
    public List<ItemTemplate> generateDrop(String dropListName, int rank, int count) {
        ArrayList drop = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            ItemTemplate itemTemplate;
            ItemType itemType;
            NavigableMap<Double, Integer> map2;
            Double key2;
            NavigableMap<Double, ItemType> map = this.lootDrops.getOrDefault(dropListName, Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap());
            Double key = map.ceilingKey(Math.random());
            if (key == null || (key2 = (map2 = this.lootWeights.getOrDefault((Object)(itemType = (ItemType)((Object)map.get(key))), Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap())).ceilingKey(Math.random())) == null || (itemTemplate = this.itemTemplates.get(map2.get(key2))) == null) continue;
            drop.add(itemTemplate);
        }
        return drop;
    }

    private void preProcessItemTemplates() {
        for (ItemTemplate itemTemplate : this.itemTemplates.values()) {
            itemTemplate.preProcess();
        }
        for (ItemTemplate itemTemplate : this.skillTemplates.values()) {
            itemTemplate.preProcess();
        }
    }
}

