/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.common.LootWeight;
import ru.quadcom.datapack.templates.item.ItemTemplate;

public class LootWeightLoader
extends Loader<LootWeight> {
    private final Map<Integer, ItemTemplate> itemTemplates;

    public LootWeightLoader(String resourceUrl, String prefix, Map<Integer, ItemTemplate> itemTemplates) {
        super(resourceUrl, prefix);
        this.itemTemplates = itemTemplates;
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<LootWeight>>(){}.getType();
    }

    @Override
    public Map<ItemType, Map<Integer, NavigableMap<Double, Integer>>> load(String fileName) {
        Collection lootWeights = StreamEx.of(this.load0(fileName)).toMap(LootWeight::getItemTemplateId, lootWeight -> lootWeight, (key, value) -> value).values();
        HashMap map = Maps.newHashMap();
        for (LootWeight lootWeight2 : lootWeights) {
            ItemTemplate itemTemplate = this.itemTemplates.get(lootWeight2.getItemTemplateId());
            if (itemTemplate == null) continue;
            map.compute(itemTemplate.getItemType(), (key, value) -> {
                if (value == null) {
                    value = Maps.newHashMap();
                }
                for (Map.Entry<Integer, Double> weight : lootWeight2.getWeights().entrySet()) {
                    value.compute(weight.getKey(), (key1, value1) -> {
                        double lastKey = 0.0;
                        if (value1 == null) {
                            value1 = Maps.newTreeMap();
                        } else {
                            lastKey = (Double)value1.lastKey();
                        }
                        value1.putIfAbsent(lastKey + (Double)weight.getValue(), lootWeight2.getItemTemplateId());
                        return value1;
                    });
                }
                return value;
            });
        }
        return map;
    }
}

