/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.loaders.impl.NPCGenerationLoader;
import ru.quadcom.datapack.loaders.impl.NpcLoader;
import ru.quadcom.datapack.services.INPCPack;
import ru.quadcom.datapack.templates.contract.ContractNpcDifficulty;
import ru.quadcom.datapack.templates.npc.NPCGeneration;
import ru.quadcom.datapack.templates.npc.NpcTemplate;

public class NPCPack
implements INPCPack {
    private final String prefix = "";
    private Map<ContractNpcDifficulty, NPCGeneration> npcGeneration;
    private Map<Integer, NpcTemplate> npc;
    private Map<String, List<NpcTemplate>> npcsByMissionId;

    NPCPack(String resourceUrl) {
        this.npcGeneration = new NPCGenerationLoader(resourceUrl, "").load("npc_generation.json");
        this.npc = new NpcLoader(resourceUrl, "").load("npc.json");
        this.npcsByMissionId = new HashMap<String, List<NpcTemplate>>();
        for (NpcTemplate npc : this.npc.values()) {
            if (!this.npcsByMissionId.containsKey(npc.getMissionId())) {
                this.npcsByMissionId.put(npc.getMissionId(), new ArrayList());
            }
            this.npcsByMissionId.get(npc.getMissionId()).add(npc);
        }
    }

    @Override
    public NPCGeneration getGeneration(ContractNpcDifficulty difficulty) {
        return this.npcGeneration.get((Object)difficulty);
    }

    @Override
    public NpcTemplate getNpcTemplate(int id) {
        return this.npc.get(id);
    }

    @Override
    public List<NpcTemplate> getNpcTemplatesByMissionId(String missionId) {
        return this.npcsByMissionId.get(missionId);
    }
}

