/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.loaders.impl.AchievementLoader;
import ru.quadcom.datapack.services.IAchievementPack;
import ru.quadcom.datapack.templates.achievement.AchievementTemplate;
import ru.quadcom.datapack.templates.achievement.CounterType;

public class AchievementPack
implements IAchievementPack {
    private final Map<Integer, AchievementTemplate> achievements;
    private final Map<CounterType, List<AchievementTemplate>> achievementsByCounterType = Maps.newHashMap();

    public AchievementPack(String resourceUrl) {
        this.achievements = new AchievementLoader(resourceUrl, "").load("achievements.json");
        for (AchievementTemplate achievementTemplate : this.achievements.values()) {
            for (Map.Entry<CounterType, List<Integer>> entry : achievementTemplate.getCounters().entrySet()) {
                this.achievementsByCounterType.compute(entry.getKey(), (type, list) -> {
                    if (list == null) {
                        list = Lists.newArrayList((Object[])new AchievementTemplate[]{achievementTemplate});
                    } else {
                        list.add(achievementTemplate);
                    }
                    return list;
                });
            }
        }
    }

    @Override
    public AchievementTemplate getAchievementTemplate(int achievementId) {
        return this.achievements.get(achievementId);
    }

    @Override
    public List<AchievementTemplate> getAchievementTemplateByCounterType(CounterType type) {
        return this.achievementsByCounterType.get((Object)type);
    }
}

