/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.loaders.impl.ItemShopLoader;
import ru.quadcom.datapack.loaders.impl.ItemSpecialShopLoader;
import ru.quadcom.datapack.services.IShopPack;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.shop.ItemShopTemplate;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopTemplate;

public class ShopPack
implements IShopPack {
    private final String prefix = "";
    private final Map<Integer, Map<Integer, ItemShopTemplate>> itemShop;
    private final Map<Integer, Map<Integer, ItemSpecialShopTemplate>> itemSpecialShop;

    public ShopPack(String resourceUrl) {
        this.itemShop = StreamEx.of((Collection)new ItemShopLoader(resourceUrl, "").load("item_shop.json")).groupingBy(ItemShopTemplate::getFractionId, Collectors.toMap(ItemShopTemplate::getItemTemplateId, template -> template));
        this.itemSpecialShop = StreamEx.of((Collection)new ItemSpecialShopLoader(resourceUrl, "").load("item_special_shop.json")).groupingBy(ItemSpecialShopTemplate::getFractionId, Collectors.toMap(ItemSpecialShopTemplate::getItemTemplateId, template -> template));
    }

    @Override
    public Map<Integer, ItemShopTemplate> getItemShop(FractionTemplate fractionTemplate) {
        return this.itemShop.get(fractionTemplate.getId());
    }

    @Override
    public Map<Integer, ItemSpecialShopTemplate> getItemSpecialShop(FractionTemplate fractionTemplate) {
        return this.itemSpecialShop.get(fractionTemplate.getId());
    }
}

