/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.item.ItemOwnerType;
import ru.quadcom.datapack.domains.operator.EquipmentSlot;
import ru.quadcom.datapack.domains.operator.Operator;
import ru.quadcom.datapack.domains.operator.UnitTraitGroupType;
import ru.quadcom.datapack.services.IDataPack;
import ru.quadcom.datapack.services.IDomainFactory;
import ru.quadcom.datapack.templates.common.DecorationType;
import ru.quadcom.datapack.templates.common.UnitSkinColor;
import ru.quadcom.datapack.templates.common.UnitSkinPart;
import ru.quadcom.datapack.templates.operator.AvatarTemplate;
import ru.quadcom.datapack.templates.operator.ClassDecoration;
import ru.quadcom.datapack.templates.operator.ClassTemplate;
import ru.quadcom.datapack.templates.operator.FirstUnitsGenerationTemplate;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.operator.GenderTemplate;
import ru.quadcom.datapack.templates.operator.NameTemplate;
import ru.quadcom.datapack.templates.operator.NationalityTemplate;
import ru.quadcom.datapack.templates.operator.OperatorDecorationTemplate;
import ru.quadcom.datapack.templates.operator.RaceTemplate;
import ru.quadcom.datapack.templates.operator.RarityTemplate;
import ru.quadcom.datapack.templates.operator.SpikeDistributionTemplate;
import ru.quadcom.datapack.templates.operator.UnitTraitTemplate;

public abstract class AbstractDomainFactory
implements IDomainFactory {
    private final IDataPack dataPack;
    private static final Random random = new Random();

    public AbstractDomainFactory(IDataPack dataPack) {
        this.dataPack = dataPack;
    }

    @Override
    public <T extends Operator> T initOperator(T operator, FractionTemplate fraction, FirstUnitsGenerationTemplate prop) {
        NationalityTemplate nationality;
        RarityTemplate rarity;
        ClassTemplate baseClass;
        operator.setRankId(this.dataPack.getOperatorPack().getStartRank().getId());
        if (prop != null) {
            baseClass = this.dataPack.getOperatorPack().getClass(prop.getClassId());
            rarity = this.dataPack.getOperatorPack().getRarity(prop.getRarityId());
            nationality = this.dataPack.getOperatorPack().getNationality(fraction.getDefaultNationality());
        } else {
            baseClass = this.dataPack.getOperatorPack().getNextBaseClass();
            rarity = this.dataPack.getOperatorPack().getNextRarity();
            if (Math.random() > 0.5) {
                nationality = this.dataPack.getOperatorPack().getNationality(fraction.getDefaultNationality());
            } else {
                List otherNationalities = ((StreamEx)StreamEx.of(this.dataPack.getOperatorPack().getNationalities()).filter(template -> template.getId() != fraction.getDefaultNationality())).toList();
                Collections.shuffle(otherNationalities);
                nationality = (NationalityTemplate)otherNationalities.get(0);
            }
        }
        operator.addClass(baseClass);
        operator.setRarityId(rarity.getId());
        operator.setNationalityId(nationality.getId());
        operator.setSkillPoints(rarity.getBonusSkillPoint());
        RaceTemplate race = this.dataPack.getOperatorPack().getNextRace(nationality.getId());
        operator.setRaceId(race.getId());
        GenderTemplate gender = this.dataPack.getOperatorPack().getGenderByClass(baseClass.getId());
        operator.setGenderId(gender.getId());
        SpikeDistributionTemplate spikeDistribution = this.dataPack.getOperatorPack().getSpikeDistribution(race.getId(), rarity.getId());
        operator.setEndurance(random.nextInt(spikeDistribution.getMaxEndurance() - spikeDistribution.getMinEndurance()) + spikeDistribution.getMinEndurance());
        operator.setIntelligence(random.nextInt(spikeDistribution.getMaxIntelligence() - spikeDistribution.getMinIntelligence()) + spikeDistribution.getMinIntelligence());
        operator.setKnack(random.nextInt(spikeDistribution.getMaxKnack() - spikeDistribution.getMinKnack()) + spikeDistribution.getMinKnack());
        operator.setPerception(random.nextInt(spikeDistribution.getMaxPerception() - spikeDistribution.getMinPerception()) + spikeDistribution.getMinPerception());
        operator.setStrength(random.nextInt(spikeDistribution.getMaxStrength() - spikeDistribution.getMinStrength()) + spikeDistribution.getMinStrength());
        NameTemplate name = this.dataPack.getOperatorPack().getName(nationality.getId(), gender.getId());
        operator.setName(name.getName() + " " + name.getSurname());
        AvatarTemplate avatarTemplate = this.dataPack.getOperatorPack().getNextAvatar(race, gender);
        operator.setAvatarName(avatarTemplate.getAvatarName());
        operator.addAvatarLayers(avatarTemplate.getNextAvatarLayers());
        operator.setSkinParts(this.createRandomDecoration(operator.getClassIds()));
        UnitSkinColor unitSkinColor = new UnitSkinColor(fraction.getCamouflageIndex(), fraction.getLutIndex(), fraction.getSolidIndex(), race.getSkinIndex());
        operator.setSkinColors(unitSkinColor);
        UnitTraitTemplate backgroundTrait = this.dataPack.getOperatorPack().getRandomUnitTraitByGroupType(UnitTraitGroupType.Background);
        UnitTraitTemplate personalityTrait = this.dataPack.getOperatorPack().getRandomUnitTraitByGroupType(UnitTraitGroupType.Personality);
        operator.addTrait(backgroundTrait.getUnitTraitType());
        operator.addTrait(personalityTrait.getUnitTraitType());
        return operator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<UnitSkinPart> createRandomDecoration(Collection<Integer> classIds) {
        OperatorDecorationTemplate template2;
        void var6_16;
        HashMap decoration = Maps.newHashMap();
        List<Object> classDecorations = Lists.newArrayList();
        for (Integer n : classIds) {
            classDecorations = this.dataPack.getOperatorPack().getClassDecorations(n);
            if (classDecorations.isEmpty()) continue;
            break;
        }
        Map map = ((StreamEx)StreamEx.of(this.dataPack.getOperatorPack().getOperatorDecorations()).filter(OperatorDecorationTemplate::isAvailable)).groupingBy(template -> template.getUnitSkinPart().getSlotId());
        for (Map.Entry entry : map.entrySet()) {
            Object list = (List)entry.getValue();
            UnitSkinPart part = ((OperatorDecorationTemplate)list.get((int)(Math.random() * (double)list.size()))).getUnitSkinPart();
            decoration.put(part.getSlotId(), part);
        }
        for (ClassDecoration classDecoration : classDecorations) {
            this.dataPack.getOperatorPack().getOperatorDecoration(classDecoration.getOperatorDecorationId()).ifPresent(operatorDecorationTemplate -> {
                UnitSkinPart part = operatorDecorationTemplate.getUnitSkinPart();
                decoration.put(part.getSlotId(), part);
            });
        }
        UnitSkinPart unitSkinPart = (UnitSkinPart)decoration.get((Object)DecorationType.arms);
        Object var6_12 = null;
        if (unitSkinPart != null) {
            switch (unitSkinPart.getGuid()) {
                case "arms_01": {
                    String string = "shoulders_01";
                    break;
                }
                case "arms_02": {
                    String string = "shoulders_02";
                    break;
                }
                case "arms_03": {
                    String string = "shoulders_03";
                }
            }
        }
        if (var6_16 != null && (template2 = this.dataPack.getOperatorPack().getOperatorDecorationByGUID((String)var6_16)) != null) {
            decoration.put(DecorationType.shoulders, template2.getUnitSkinPart());
        }
        return Lists.newArrayList(decoration.values());
    }

    @Override
    public Item createFakeItem(Operator operator, EquipmentSlot slot, int templateId) {
        Item fakeItem = new Item();
        fakeItem.setItemTemplateId(templateId);
        fakeItem.setItemOwnerType(ItemOwnerType.OPERATOR);
        fakeItem.setOwnerInstanceId(operator.getId());
        fakeItem.setProfileId(operator.getProfileId());
        fakeItem.setSlotNumber(slot.getEquipmentOrder());
        fakeItem.setId((long)(-(Math.random() * 9.223372036854776E18)));
        fakeItem.setDurability(this.dataPack.getItemPack().getItemTemplate(templateId).getDurability());
        return fakeItem;
    }
}

